"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleAny = handleAny;
exports.handleCombination = handleCombination;
exports.handleRecursive = handleRecursive;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const regex_1 = require("../../../../util/regex");
const utils_1 = require("../utils");
const utils_2 = require("./utils");
function handleAny(content, packageFile, config) {
    return config.matchStrings
        .map((matchString) => (0, regex_1.regEx)(matchString, 'g'))
        .flatMap((regex) => (0, utils_2.regexMatchAll)(regex, content)) // match all regex to content, get all matches, reduce to single array
        .map((matchResult) => (0, utils_2.createDependency)({
        groups: matchResult.groups ??
            /* istanbul ignore next: can this happen? */ {},
        replaceString: matchResult[0],
    }, config))
        .filter(is_1.default.truthy)
        .filter((dep) => (0, utils_1.checkIsValidDependency)(dep, packageFile, 'regex'));
}
function handleCombination(content, packageFile, config) {
    const matches = config.matchStrings
        .map((matchString) => (0, regex_1.regEx)(matchString, 'g'))
        .flatMap((regex) => (0, utils_2.regexMatchAll)(regex, content)); // match all regex to content, get all matches, reduce to single array
    if (!matches.length) {
        return [];
    }
    const extraction = matches
        .map((match) => ({
        groups: match.groups ?? /* istanbul ignore next: can this happen? */ {},
        replaceString: (match?.groups?.currentValue ?? match?.groups?.currentDigest)
            ? match[0]
            : undefined,
    }))
        .reduce((base, addition) => (0, utils_2.mergeExtractionTemplate)(base, addition));
    return [(0, utils_2.createDependency)(extraction, config)]
        .filter(is_1.default.truthy)
        .filter((dep) => (0, utils_1.checkIsValidDependency)(dep, packageFile, 'regex'));
}
function handleRecursive(content, packageFile, config) {
    const regexes = config.matchStrings.map((matchString) => (0, regex_1.regEx)(matchString, 'g'));
    return processRecursive({
        content,
        packageFile,
        config,
        index: 0,
        combinedGroups: {},
        regexes,
    })
        .filter(is_1.default.truthy)
        .filter((dep) => (0, utils_1.checkIsValidDependency)(dep, packageFile, 'regex'));
}
function processRecursive(parameters) {
    const { content, index, combinedGroups, regexes, config, } = parameters;
    // abort if we have no matchString anymore
    if (regexes.length === index) {
        const result = (0, utils_2.createDependency)({
            groups: combinedGroups,
            replaceString: content,
        }, config);
        return result ? [result] : /* istanbul ignore next: can this happen? */ [];
    }
    return (0, utils_2.regexMatchAll)(regexes[index], content).flatMap((match) => {
        return processRecursive({
            ...parameters,
            content: match[0],
            index: index + 1,
            combinedGroups: (0, utils_2.mergeGroups)(combinedGroups, match.groups ?? {}),
        });
    });
}
//# sourceMappingURL=strategies.js.map