"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryResultZodSchema = void 0;
const zod_1 = require("zod");
const DepObjectSchema = zod_1.z.object({
    currentValue: zod_1.z.string().optional(),
    datasource: zod_1.z.string().optional(),
    depName: zod_1.z.string().optional(),
    packageName: zod_1.z.string().optional(),
    currentDigest: zod_1.z.string().optional(),
    versioning: zod_1.z.string().optional(),
    depType: zod_1.z.string().optional(),
    registryUrl: zod_1.z.string().optional(),
    extractVersion: zod_1.z.string().optional(),
    indentation: zod_1.z.string().optional(),
});
exports.QueryResultZodSchema = zod_1.z
    .union([zod_1.z.array(DepObjectSchema), DepObjectSchema])
    .transform((input) => {
    return Array.isArray(input) ? input : [input];
});
//# sourceMappingURL=schema.js.map