"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.XPKGSchema = void 0;
const zod_1 = require("zod");
const regex_1 = require("../../../util/regex");
exports.XPKGSchema = zod_1.z.object({
    apiVersion: zod_1.z.string().regex((0, regex_1.regEx)(/^pkg\.crossplane\.io\//)),
    kind: zod_1.z.enum(['Provider', 'Configuration', 'Function']),
    spec: zod_1.z.object({
        package: zod_1.z.string(),
    }),
});
//# sourceMappingURL=schema.js.map