import { z } from 'zod';
export declare const XPKGSchema: z.ZodObject<{
    apiVersion: z.ZodString;
    kind: z.ZodEnum<["Provider", "Configuration", "Function"]>;
    spec: z.ZodObject<{
        package: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        package: string;
    }, {
        package: string;
    }>;
}, "strip", z.ZodTypeAny, {
    apiVersion: string;
    kind: "Provider" | "Configuration" | "Function";
    spec: {
        package: string;
    };
}, {
    apiVersion: string;
    kind: "Provider" | "Configuration" | "Function";
    spec: {
        package: string;
    };
}>;
export type XPKG = z.infer<typeof XPKGSchema>;
