"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const yaml_1 = require("../../../util/yaml");
const extract_1 = require("../dockerfile/extract");
const schema_1 = require("./schema");
function extractPackageFile(content, packageFile, extractConfig) {
    // avoid parsing the whole file if it doesn't contain any resource having any pkg.crossplane.io/v*
    if (!/apiVersion:\s+["']?pkg\.crossplane\.io\/v.+["']?/.test(content)) {
        logger_1.logger.trace({ packageFile }, 'No Crossplane package found in file.');
        return null;
    }
    // not try and catching this as failureBehaviour is set to filter and therefore it will not throw
    const list = (0, yaml_1.parseYaml)(content, {
        customSchema: schema_1.XPKGSchema,
        failureBehaviour: 'filter',
    });
    const deps = [];
    for (const xpkg of list) {
        const dep = (0, extract_1.getDep)(xpkg.spec.package, true, extractConfig?.registryAliases);
        dep.depType = xpkg.kind.toLowerCase();
        deps.push(dep);
    }
    return deps.length ? { deps } : null;
}
//# sourceMappingURL=extract.js.map