"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const git_tags_1 = require("../../datasource/git-tags");
const schema_1 = require("./schema");
function extractPackageFile(content, packageFile) {
    let parsed;
    try {
        parsed = schema_1.CopierAnswersFile.parse(content);
    }
    catch (err) {
        logger_1.logger.debug({ err, packageFile }, `Parsing Copier answers YAML failed`);
        return null;
    }
    const deps = [
        {
            datasource: git_tags_1.GitTagsDatasource.id,
            depName: parsed._src_path,
            packageName: parsed._src_path,
            depType: 'template',
            currentValue: parsed._commit,
        },
    ];
    return {
        deps,
    };
}
//# sourceMappingURL=extract.js.map