import type { CombinedHostRule } from '../../../types';
import type { ToolConstraint } from '../../../util/exec/types';
import { id as composerVersioningId } from '../../versioning/composer';
import type { UpdateArtifactsConfig } from '../types';
import type { Lockfile, PackageFile } from './schema';
export { composerVersioningId };
export declare function getComposerArguments(config: UpdateArtifactsConfig, toolConstraint: ToolConstraint): string;
export declare function getComposerUpdateArguments(config: UpdateArtifactsConfig, toolConstraint: ToolConstraint): string;
export declare function getPhpConstraint(constraints: Record<string, string>): string | null;
export declare function requireComposerDependencyInstallation({ packages, packagesDev, }: Lockfile): boolean;
export declare function extractConstraints({ config, require, requireDev }: PackageFile, { pluginApiVersion }: Lockfile): Record<string, string>;
export declare function isArtifactAuthEnabled(rule: CombinedHostRule): boolean;
