import { z } from 'zod';
import type { PackageFileContent } from '../types';
import type { ComposerManagerData } from './types';
export declare const ComposerRepo: z.ZodObject<{
    type: z.ZodLiteral<"composer">;
    /**
     * The regUrl is expected to be a base URL. GitLab composer repository installation guide specifies
     * to use a base URL containing packages.json. Composer still works in this scenario by determining
     * whether to add / remove packages.json from the URL.
     *
     * See https://github.com/composer/composer/blob/750a92b4b7aecda0e5b2f9b963f1cb1421900675/src/Composer/Repository/ComposerRepository.php#L815
     */
    url: z.ZodEffects<z.ZodString, string, string>;
}, "strip", z.ZodTypeAny, {
    type: "composer";
    url: string;
}, {
    type: "composer";
    url: string;
}>;
export type ComposerRepo = z.infer<typeof ComposerRepo>;
export declare const GitRepo: z.ZodObject<{
    type: z.ZodEffects<z.ZodEnum<["vcs", "git"]>, "git", "git" | "vcs">;
    url: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "git";
    url: string;
    name?: string | undefined;
}, {
    type: "git" | "vcs";
    url: string;
    name?: string | undefined;
}>;
export type GitRepo = z.infer<typeof GitRepo>;
export declare const PathRepo: z.ZodObject<{
    type: z.ZodLiteral<"path">;
    url: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "path";
    url: string;
    name?: string | undefined;
}, {
    type: "path";
    url: string;
    name?: string | undefined;
}>;
export type PathRepo = z.infer<typeof PathRepo>;
export declare const PackageRepo: z.ZodObject<{
    type: z.ZodLiteral<"package">;
}, "strip", z.ZodTypeAny, {
    type: "package";
}, {
    type: "package";
}>;
export declare const Repo: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
    type: z.ZodLiteral<"composer">;
    /**
     * The regUrl is expected to be a base URL. GitLab composer repository installation guide specifies
     * to use a base URL containing packages.json. Composer still works in this scenario by determining
     * whether to add / remove packages.json from the URL.
     *
     * See https://github.com/composer/composer/blob/750a92b4b7aecda0e5b2f9b963f1cb1421900675/src/Composer/Repository/ComposerRepository.php#L815
     */
    url: z.ZodEffects<z.ZodString, string, string>;
}, "strip", z.ZodTypeAny, {
    type: "composer";
    url: string;
}, {
    type: "composer";
    url: string;
}>, z.ZodObject<{
    type: z.ZodEffects<z.ZodEnum<["vcs", "git"]>, "git", "git" | "vcs">;
    url: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "git";
    url: string;
    name?: string | undefined;
}, {
    type: "git" | "vcs";
    url: string;
    name?: string | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"path">;
    url: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "path";
    url: string;
    name?: string | undefined;
}, {
    type: "path";
    url: string;
    name?: string | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"package">;
}, "strip", z.ZodTypeAny, {
    type: "package";
}, {
    type: "package";
}>]>;
export type Repo = z.infer<typeof ComposerRepo>;
export declare const NamedRepo: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
    type: z.ZodLiteral<"composer">;
    /**
     * The regUrl is expected to be a base URL. GitLab composer repository installation guide specifies
     * to use a base URL containing packages.json. Composer still works in this scenario by determining
     * whether to add / remove packages.json from the URL.
     *
     * See https://github.com/composer/composer/blob/750a92b4b7aecda0e5b2f9b963f1cb1421900675/src/Composer/Repository/ComposerRepository.php#L815
     */
    url: z.ZodEffects<z.ZodString, string, string>;
}, "strip", z.ZodTypeAny, {
    type: "composer";
    url: string;
}, {
    type: "composer";
    url: string;
}>, z.ZodObject<{
    type: z.ZodEffects<z.ZodEnum<["vcs", "git"]>, "git", "git" | "vcs">;
    url: z.ZodString;
} & {
    name: z.ZodString;
}, "strip", z.ZodTypeAny, {
    type: "git";
    url: string;
    name: string;
}, {
    type: "git" | "vcs";
    url: string;
    name: string;
}>, z.ZodObject<{
    type: z.ZodLiteral<"path">;
    url: z.ZodString;
} & {
    name: z.ZodString;
}, "strip", z.ZodTypeAny, {
    type: "path";
    url: string;
    name: string;
}, {
    type: "path";
    url: string;
    name: string;
}>, z.ZodObject<{
    type: z.ZodLiteral<"package">;
}, "strip", z.ZodTypeAny, {
    type: "package";
}, {
    type: "package";
}>]>;
export type NamedRepo = z.infer<typeof NamedRepo>;
declare const DisablePackagist: z.ZodObject<{
    type: z.ZodLiteral<"disable-packagist">;
}, "strip", z.ZodTypeAny, {
    type: "disable-packagist";
}, {
    type: "disable-packagist";
}>;
export type DisablePackagist = z.infer<typeof DisablePackagist>;
export declare const ReposRecord: z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, false | {
    type: "composer";
    url: string;
} | {
    type: "git";
    url: string;
    name?: string | undefined;
} | {
    type: "path";
    url: string;
    name?: string | undefined;
} | {
    type: "package";
}>, Record<string, any>>, ({
    type: "composer";
    url: string;
} | {
    type: "package";
} | {
    type: "git";
    url: string;
    name: string;
} | {
    type: "path";
    url: string;
    name: string;
} | {
    type: "disable-packagist";
})[], Record<string, any>>;
export type ReposRecord = z.infer<typeof ReposRecord>;
export declare const ReposArray: z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
    type: "composer";
    url: string;
} | {
    type: "git";
    url: string;
    name?: string | undefined;
} | {
    type: "path";
    url: string;
    name?: string | undefined;
} | {
    type: "package";
} | {
    type: "disable-packagist";
})[], any[]>, ({
    type: "composer";
    url: string;
} | {
    type: "package";
} | {
    type: "git";
    url: string;
    name: string;
} | {
    type: "path";
    url: string;
    name: string;
} | {
    type: "disable-packagist";
})[], any[]>;
export type ReposArray = z.infer<typeof ReposArray>;
export declare const Repos: z.ZodEffects<z.ZodCatch<z.ZodDefault<z.ZodUnion<[z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, false | {
    type: "composer";
    url: string;
} | {
    type: "git";
    url: string;
    name?: string | undefined;
} | {
    type: "path";
    url: string;
    name?: string | undefined;
} | {
    type: "package";
}>, Record<string, any>>, ({
    type: "composer";
    url: string;
} | {
    type: "package";
} | {
    type: "git";
    url: string;
    name: string;
} | {
    type: "path";
    url: string;
    name: string;
} | {
    type: "disable-packagist";
})[], Record<string, any>>, z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
    type: "composer";
    url: string;
} | {
    type: "git";
    url: string;
    name?: string | undefined;
} | {
    type: "path";
    url: string;
    name?: string | undefined;
} | {
    type: "package";
} | {
    type: "disable-packagist";
})[], any[]>, ({
    type: "composer";
    url: string;
} | {
    type: "package";
} | {
    type: "git";
    url: string;
    name: string;
} | {
    type: "path";
    url: string;
    name: string;
} | {
    type: "disable-packagist";
})[], any[]>]>>>, {
    registryUrls: string[] | null;
    gitRepos: Record<string, {
        type: "git";
        url: string;
        name?: string | undefined;
    }>;
    pathRepos: Record<string, {
        type: "path";
        url: string;
        name?: string | undefined;
    }>;
}, unknown>;
export type Repos = z.infer<typeof Repos>;
export declare const PackageFile: z.ZodEffects<z.ZodObject<{
    type: z.ZodOptional<z.ZodString>;
    config: z.ZodCatch<z.ZodNullable<z.ZodObject<{
        platform: z.ZodObject<{
            php: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            php: string;
        }, {
            php: string;
        }>;
    }, "strip", z.ZodTypeAny, {
        platform: {
            php: string;
        };
    }, {
        platform: {
            php: string;
        };
    }>>>;
    repositories: z.ZodEffects<z.ZodCatch<z.ZodDefault<z.ZodUnion<[z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, false | {
        type: "composer";
        url: string;
    } | {
        type: "git";
        url: string;
        name?: string | undefined;
    } | {
        type: "path";
        url: string;
        name?: string | undefined;
    } | {
        type: "package";
    }>, Record<string, any>>, ({
        type: "composer";
        url: string;
    } | {
        type: "package";
    } | {
        type: "git";
        url: string;
        name: string;
    } | {
        type: "path";
        url: string;
        name: string;
    } | {
        type: "disable-packagist";
    })[], Record<string, any>>, z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
        type: "composer";
        url: string;
    } | {
        type: "git";
        url: string;
        name?: string | undefined;
    } | {
        type: "path";
        url: string;
        name?: string | undefined;
    } | {
        type: "package";
    } | {
        type: "disable-packagist";
    })[], any[]>, ({
        type: "composer";
        url: string;
    } | {
        type: "package";
    } | {
        type: "git";
        url: string;
        name: string;
    } | {
        type: "path";
        url: string;
        name: string;
    } | {
        type: "disable-packagist";
    })[], any[]>]>>>, {
        registryUrls: string[] | null;
        gitRepos: Record<string, {
            type: "git";
            url: string;
            name?: string | undefined;
        }>;
        pathRepos: Record<string, {
            type: "path";
            url: string;
            name?: string | undefined;
        }>;
    }, unknown>;
    require: z.ZodCatch<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    'require-dev': z.ZodCatch<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    config: {
        platform: {
            php: string;
        };
    } | null;
    repositories: {
        registryUrls: string[] | null;
        gitRepos: Record<string, {
            type: "git";
            url: string;
            name?: string | undefined;
        }>;
        pathRepos: Record<string, {
            type: "path";
            url: string;
            name?: string | undefined;
        }>;
    };
    require: Record<string, string>;
    'require-dev': Record<string, string>;
    type?: string | undefined;
}, {
    type?: string | undefined;
    config?: unknown;
    repositories?: unknown;
    require?: unknown;
    'require-dev'?: unknown;
}>, {
    composerJsonType: string | undefined;
    config: {
        platform: {
            php: string;
        };
    } | null;
    repositories: {
        registryUrls: string[] | null;
        gitRepos: Record<string, {
            type: "git";
            url: string;
            name?: string | undefined;
        }>;
        pathRepos: Record<string, {
            type: "path";
            url: string;
            name?: string | undefined;
        }>;
    };
    require: Record<string, string>;
    requireDev: Record<string, string>;
}, {
    type?: string | undefined;
    config?: unknown;
    repositories?: unknown;
    require?: unknown;
    'require-dev'?: unknown;
}>;
export type PackageFile = z.infer<typeof PackageFile>;
export declare const Lockfile: z.ZodEffects<z.ZodObject<{
    'plugin-api-version': z.ZodOptional<z.ZodString>;
    packages: z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        name: string;
        version: string;
    }[], any[]>>;
    'packages-dev': z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        name: string;
        version: string;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    packages: {
        name: string;
        version: string;
    }[];
    'packages-dev': {
        name: string;
        version: string;
    }[];
    'plugin-api-version'?: string | undefined;
}, {
    packages?: unknown;
    'plugin-api-version'?: string | undefined;
    'packages-dev'?: unknown;
}>, {
    pluginApiVersion: string | undefined;
    packages: {
        name: string;
        version: string;
    }[];
    packagesDev: {
        name: string;
        version: string;
    }[];
}, {
    packages?: unknown;
    'plugin-api-version'?: string | undefined;
    'packages-dev'?: unknown;
}>;
export type Lockfile = z.infer<typeof Lockfile>;
export declare const ComposerExtract: z.ZodEffects<z.ZodPipeline<z.ZodEffects<z.ZodObject<{
    content: z.ZodString;
    fileName: z.ZodString;
}, "strip", z.ZodTypeAny, {
    content: string;
    fileName: string;
}, {
    content: string;
    fileName: string;
}>, {
    file: string;
    lockfileName: string;
    lockfile: string;
}, {
    content: string;
    fileName: string;
}>, z.ZodObject<{
    file: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodEffects<z.ZodObject<{
        type: z.ZodOptional<z.ZodString>;
        config: z.ZodCatch<z.ZodNullable<z.ZodObject<{
            platform: z.ZodObject<{
                php: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                php: string;
            }, {
                php: string;
            }>;
        }, "strip", z.ZodTypeAny, {
            platform: {
                php: string;
            };
        }, {
            platform: {
                php: string;
            };
        }>>>;
        repositories: z.ZodEffects<z.ZodCatch<z.ZodDefault<z.ZodUnion<[z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, false | {
            type: "composer";
            url: string;
        } | {
            type: "git";
            url: string;
            name?: string | undefined;
        } | {
            type: "path";
            url: string;
            name?: string | undefined;
        } | {
            type: "package";
        }>, Record<string, any>>, ({
            type: "composer";
            url: string;
        } | {
            type: "package";
        } | {
            type: "git";
            url: string;
            name: string;
        } | {
            type: "path";
            url: string;
            name: string;
        } | {
            type: "disable-packagist";
        })[], Record<string, any>>, z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
            type: "composer";
            url: string;
        } | {
            type: "git";
            url: string;
            name?: string | undefined;
        } | {
            type: "path";
            url: string;
            name?: string | undefined;
        } | {
            type: "package";
        } | {
            type: "disable-packagist";
        })[], any[]>, ({
            type: "composer";
            url: string;
        } | {
            type: "package";
        } | {
            type: "git";
            url: string;
            name: string;
        } | {
            type: "path";
            url: string;
            name: string;
        } | {
            type: "disable-packagist";
        })[], any[]>]>>>, {
            registryUrls: string[] | null;
            gitRepos: Record<string, {
                type: "git";
                url: string;
                name?: string | undefined;
            }>;
            pathRepos: Record<string, {
                type: "path";
                url: string;
                name?: string | undefined;
            }>;
        }, unknown>;
        require: z.ZodCatch<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
        'require-dev': z.ZodCatch<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string>, Record<string, any>>>;
    }, "strip", z.ZodTypeAny, {
        config: {
            platform: {
                php: string;
            };
        } | null;
        repositories: {
            registryUrls: string[] | null;
            gitRepos: Record<string, {
                type: "git";
                url: string;
                name?: string | undefined;
            }>;
            pathRepos: Record<string, {
                type: "path";
                url: string;
                name?: string | undefined;
            }>;
        };
        require: Record<string, string>;
        'require-dev': Record<string, string>;
        type?: string | undefined;
    }, {
        type?: string | undefined;
        config?: unknown;
        repositories?: unknown;
        require?: unknown;
        'require-dev'?: unknown;
    }>, {
        composerJsonType: string | undefined;
        config: {
            platform: {
                php: string;
            };
        } | null;
        repositories: {
            registryUrls: string[] | null;
            gitRepos: Record<string, {
                type: "git";
                url: string;
                name?: string | undefined;
            }>;
            pathRepos: Record<string, {
                type: "path";
                url: string;
                name?: string | undefined;
            }>;
        };
        require: Record<string, string>;
        requireDev: Record<string, string>;
    }, {
        type?: string | undefined;
        config?: unknown;
        repositories?: unknown;
        require?: unknown;
        'require-dev'?: unknown;
    }>>;
    lockfileName: z.ZodString;
    lockfile: z.ZodPipeline<z.ZodEffects<z.ZodString, string | null, string>, z.ZodUnion<[z.ZodNull, z.ZodCatch<z.ZodNullable<z.ZodPipeline<z.ZodPipeline<z.ZodString, z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>>, z.ZodEffects<z.ZodObject<{
        'plugin-api-version': z.ZodOptional<z.ZodString>;
        packages: z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            name: string;
            version: string;
        }[], any[]>>;
        'packages-dev': z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            name: string;
            version: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        packages: {
            name: string;
            version: string;
        }[];
        'packages-dev': {
            name: string;
            version: string;
        }[];
        'plugin-api-version'?: string | undefined;
    }, {
        packages?: unknown;
        'plugin-api-version'?: string | undefined;
        'packages-dev'?: unknown;
    }>, {
        pluginApiVersion: string | undefined;
        packages: {
            name: string;
            version: string;
        }[];
        packagesDev: {
            name: string;
            version: string;
        }[];
    }, {
        packages?: unknown;
        'plugin-api-version'?: string | undefined;
        'packages-dev'?: unknown;
    }>>>>]>>;
}, "strip", z.ZodTypeAny, {
    file: {
        composerJsonType: string | undefined;
        config: {
            platform: {
                php: string;
            };
        } | null;
        repositories: {
            registryUrls: string[] | null;
            gitRepos: Record<string, {
                type: "git";
                url: string;
                name?: string | undefined;
            }>;
            pathRepos: Record<string, {
                type: "path";
                url: string;
                name?: string | undefined;
            }>;
        };
        require: Record<string, string>;
        requireDev: Record<string, string>;
    };
    lockfile: {
        pluginApiVersion: string | undefined;
        packages: {
            name: string;
            version: string;
        }[];
        packagesDev: {
            name: string;
            version: string;
        }[];
    } | null;
    lockfileName: string;
}, {
    file: string;
    lockfile: string;
    lockfileName: string;
}>>, PackageFileContent<ComposerManagerData> | null, {
    content: string;
    fileName: string;
}>;
export type ComposerExtract = z.infer<typeof ComposerExtract>;
export {};
