"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRangeStrategy = getRangeStrategy;
const logger_1 = require("../../../logger");
function getRangeStrategy(config) {
    const { managerData = {}, currentValue, rangeStrategy } = config;
    const { composerJsonType } = managerData;
    const isComplexRange = currentValue?.includes(' || ') ?? false;
    if (rangeStrategy === 'bump' && isComplexRange) {
        logger_1.logger.debug({ currentValue }, 'Replacing bump strategy for complex range with widen');
        return 'widen';
    }
    if (rangeStrategy !== 'auto') {
        return rangeStrategy;
    }
    if (isComplexRange ||
        (composerJsonType && ['typo3-cms-extension'].includes(composerJsonType))) {
        return 'widen';
    }
    return 'update-lockfile';
}
//# sourceMappingURL=range.js.map