"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.updateLockedDependency = exports.getRangeStrategy = exports.updateArtifacts = exports.extractPackageFile = exports.supportsLockFileMaintenance = void 0;
const bitbucket_tags_1 = require("../../datasource/bitbucket-tags");
const git_tags_1 = require("../../datasource/git-tags");
const packagist_1 = require("../../datasource/packagist");
const artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
const extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
const range_1 = require("./range");
Object.defineProperty(exports, "getRangeStrategy", { enumerable: true, get: function () { return range_1.getRangeStrategy; } });
const update_locked_1 = require("./update-locked");
Object.defineProperty(exports, "updateLockedDependency", { enumerable: true, get: function () { return update_locked_1.updateLockedDependency; } });
const utils_1 = require("./utils");
exports.supportsLockFileMaintenance = true;
exports.url = 'https://getcomposer.org/doc';
exports.categories = ['php'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)([\\w-]*)composer\\.json$/'],
    versioning: utils_1.composerVersioningId,
};
exports.supportedDatasources = [
    bitbucket_tags_1.BitbucketTagsDatasource.id,
    git_tags_1.GitTagsDatasource.id,
    packagist_1.PackagistDatasource.id,
];
//# sourceMappingURL=index.js.map