"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const schema_1 = require("./schema");
async function extractPackageFile(content, packageFile) {
    const res = await schema_1.ComposerExtract.safeParseAsync({
        content,
        fileName: packageFile,
    });
    if (!res.success) {
        logger_1.logger.debug({ packageFile, err: res.error }, 'Composer: extract failed');
        return null;
    }
    return res.data;
}
//# sourceMappingURL=extract.js.map