"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const extract_1 = require("../dockerfile/extract");
const schema_1 = require("./schema");
function extractPackageFile(content, packageFile) {
    const deps = schema_1.CloudbuildSteps.catch(({ error: err }) => {
        logger_1.logger.debug({ err, packageFile }, 'Cloud Build: error extracting Docker images from a configuration file.');
        return [];
    })
        .transform((steps) => steps.map((step) => (0, extract_1.getDep)(step)))
        .parse(content);
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map