"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CircleCiFile = exports.CircleCiOrb = exports.CircleCiJob = exports.CircleCiDocker = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
exports.CircleCiDocker = zod_1.z
    .object({ image: zod_1.z.string() })
    .transform(({ image }) => image);
exports.CircleCiJob = zod_1.z
    .object({
    docker: (0, schema_utils_1.LooseArray)(exports.CircleCiDocker).catch([]),
})
    .transform(({ docker }) => docker);
const CircleCiJobList = (0, schema_utils_1.LooseRecord)(exports.CircleCiJob)
    .transform((x) => Object.values(x).flat())
    .catch([]);
const BaseOrb = zod_1.z.object({
    executors: CircleCiJobList,
    jobs: CircleCiJobList,
});
exports.CircleCiOrb = BaseOrb.extend({
    orbs: (0, schema_utils_1.LooseRecord)(zod_1.z.union([zod_1.z.string(), zod_1.z.lazy(() => exports.CircleCiOrb)])).catch({}),
});
exports.CircleCiFile = schema_utils_1.NotCircular.pipe(BaseOrb.extend({
    aliases: (0, schema_utils_1.LooseArray)(exports.CircleCiDocker).catch([]),
    orbs: (0, schema_utils_1.LooseRecord)(zod_1.z.union([zod_1.z.string(), exports.CircleCiOrb])).catch({}),
}));
//# sourceMappingURL=schema.js.map