import { z } from 'zod';
export declare const CircleCiDocker: z.ZodEffects<z.ZodObject<{
    image: z.ZodString;
}, "strip", z.ZodTypeAny, {
    image: string;
}, {
    image: string;
}>, string, {
    image: string;
}>;
export declare const CircleCiJob: z.ZodEffects<z.ZodObject<{
    docker: z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
}, "strip", z.ZodTypeAny, {
    docker: string[];
}, {
    docker?: unknown;
}>, string[], {
    docker?: unknown;
}>;
export type CircleCiJob = z.infer<typeof CircleCiJob>;
declare const BaseOrb: z.ZodObject<{
    executors: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string[]>, Record<string, any>>, string[], Record<string, any>>>;
    jobs: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string[]>, Record<string, any>>, string[], Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    jobs: string[];
    executors: string[];
}, {
    jobs?: unknown;
    executors?: unknown;
}>;
type Orb = z.infer<typeof BaseOrb> & {
    orbs: Record<string, string | Orb>;
};
export declare const CircleCiOrb: z.ZodType<Orb>;
export type CircleCiOrb = z.infer<typeof CircleCiOrb>;
export declare const CircleCiFile: z.ZodPipeline<z.ZodEffects<z.ZodUnknown, unknown, unknown>, z.ZodObject<{
    executors: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string[]>, Record<string, any>>, string[], Record<string, any>>>;
    jobs: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string[]>, Record<string, any>>, string[], Record<string, any>>>;
} & {
    aliases: z.ZodCatch<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
    orbs: z.ZodCatch<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, string | Orb>, Record<string, any>>>;
}, "strip", z.ZodTypeAny, {
    aliases: string[];
    jobs: string[];
    executors: string[];
    orbs: Record<string, string | Orb>;
}, {
    aliases?: unknown;
    jobs?: unknown;
    executors?: unknown;
    orbs?: unknown;
}>>;
export type CircleCiFile = z.infer<typeof CircleCiFile>;
export {};
