import { z } from 'zod';
import type { PackageDependency } from '../types';
import type { CargoManagerData } from './types';
declare const CargoDeps: z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    /** Path on disk to the crate sources */
    path: z.ZodOptional<z.ZodString>;
    /** Git URL for the dependency */
    git: z.ZodOptional<z.ZodString>;
    /** Semver version */
    version: z.ZodOptional<z.ZodString>;
    /** Name of a registry whose URL is configured in `.cargo/config.toml` or `.cargo/config` */
    registry: z.ZodOptional<z.ZodString>;
    /** Name of a package to look up */
    package: z.ZodOptional<z.ZodString>;
    /** Whether the dependency is inherited from the workspace */
    workspace: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    path?: string | undefined;
    version?: string | undefined;
    git?: string | undefined;
    package?: string | undefined;
    registry?: string | undefined;
    workspace?: boolean | undefined;
}, {
    path?: string | undefined;
    version?: string | undefined;
    git?: string | undefined;
    package?: string | undefined;
    registry?: string | undefined;
    workspace?: boolean | undefined;
}>, PackageDependency<CargoManagerData>, {
    path?: string | undefined;
    version?: string | undefined;
    git?: string | undefined;
    package?: string | undefined;
    registry?: string | undefined;
    workspace?: boolean | undefined;
}>, z.ZodEffects<z.ZodString, PackageDependency<CargoManagerData>, string>]>>, PackageDependency<Record<string, any>>[], Record<string, string | {
    path?: string | undefined;
    version?: string | undefined;
    git?: string | undefined;
    package?: string | undefined;
    registry?: string | undefined;
    workspace?: boolean | undefined;
}>>;
export type CargoDeps = z.infer<typeof CargoDeps>;
export declare const CargoManifestSchema: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    dependencies: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodEffects<z.ZodObject<{
        /** Path on disk to the crate sources */
        path: z.ZodOptional<z.ZodString>;
        /** Git URL for the dependency */
        git: z.ZodOptional<z.ZodString>;
        /** Semver version */
        version: z.ZodOptional<z.ZodString>;
        /** Name of a registry whose URL is configured in `.cargo/config.toml` or `.cargo/config` */
        registry: z.ZodOptional<z.ZodString>;
        /** Name of a package to look up */
        package: z.ZodOptional<z.ZodString>;
        /** Whether the dependency is inherited from the workspace */
        workspace: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>, PackageDependency<CargoManagerData>, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>, z.ZodEffects<z.ZodString, PackageDependency<CargoManagerData>, string>]>>, PackageDependency<Record<string, any>>[], Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>>, PackageDependency<Record<string, any>>[], Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>>>;
    'dev-dependencies': z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodEffects<z.ZodObject<{
        /** Path on disk to the crate sources */
        path: z.ZodOptional<z.ZodString>;
        /** Git URL for the dependency */
        git: z.ZodOptional<z.ZodString>;
        /** Semver version */
        version: z.ZodOptional<z.ZodString>;
        /** Name of a registry whose URL is configured in `.cargo/config.toml` or `.cargo/config` */
        registry: z.ZodOptional<z.ZodString>;
        /** Name of a package to look up */
        package: z.ZodOptional<z.ZodString>;
        /** Whether the dependency is inherited from the workspace */
        workspace: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>, PackageDependency<CargoManagerData>, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>, z.ZodEffects<z.ZodString, PackageDependency<CargoManagerData>, string>]>>, PackageDependency<Record<string, any>>[], Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>>, PackageDependency<Record<string, any>>[], Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>>>;
    'build-dependencies': z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodEffects<z.ZodObject<{
        /** Path on disk to the crate sources */
        path: z.ZodOptional<z.ZodString>;
        /** Git URL for the dependency */
        git: z.ZodOptional<z.ZodString>;
        /** Semver version */
        version: z.ZodOptional<z.ZodString>;
        /** Name of a registry whose URL is configured in `.cargo/config.toml` or `.cargo/config` */
        registry: z.ZodOptional<z.ZodString>;
        /** Name of a package to look up */
        package: z.ZodOptional<z.ZodString>;
        /** Whether the dependency is inherited from the workspace */
        workspace: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>, PackageDependency<CargoManagerData>, {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>, z.ZodEffects<z.ZodString, PackageDependency<CargoManagerData>, string>]>>, PackageDependency<Record<string, any>>[], Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>>, PackageDependency<Record<string, any>>[], Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }>>>;
} & {
    package: z.ZodOptional<z.ZodObject<{
        version: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodObject<{
            workspace: z.ZodLiteral<true>;
        }, "strip", z.ZodTypeAny, {
            workspace: true;
        }, {
            workspace: true;
        }>]>>;
    }, "strip", z.ZodTypeAny, {
        version?: string | {
            workspace: true;
        } | undefined;
    }, {
        version?: string | {
            workspace: true;
        } | undefined;
    }>>;
    workspace: z.ZodOptional<z.ZodObject<{
        dependencies: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodEffects<z.ZodObject<{
            /** Path on disk to the crate sources */
            path: z.ZodOptional<z.ZodString>;
            /** Git URL for the dependency */
            git: z.ZodOptional<z.ZodString>;
            /** Semver version */
            version: z.ZodOptional<z.ZodString>;
            /** Name of a registry whose URL is configured in `.cargo/config.toml` or `.cargo/config` */
            registry: z.ZodOptional<z.ZodString>;
            /** Name of a package to look up */
            package: z.ZodOptional<z.ZodString>;
            /** Whether the dependency is inherited from the workspace */
            workspace: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>, PackageDependency<CargoManagerData>, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>, z.ZodEffects<z.ZodString, PackageDependency<CargoManagerData>, string>]>>, PackageDependency<Record<string, any>>[], Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>>, PackageDependency<Record<string, any>>[], Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>>>;
        package: z.ZodOptional<z.ZodObject<{
            version: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            version?: string | undefined;
        }, {
            version?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        package?: {
            version?: string | undefined;
        } | undefined;
        dependencies?: PackageDependency<Record<string, any>>[] | undefined;
    }, {
        package?: {
            version?: string | undefined;
        } | undefined;
        dependencies?: Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }> | undefined;
    }>>;
    target: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        dependencies: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodEffects<z.ZodObject<{
            /** Path on disk to the crate sources */
            path: z.ZodOptional<z.ZodString>;
            /** Git URL for the dependency */
            git: z.ZodOptional<z.ZodString>;
            /** Semver version */
            version: z.ZodOptional<z.ZodString>;
            /** Name of a registry whose URL is configured in `.cargo/config.toml` or `.cargo/config` */
            registry: z.ZodOptional<z.ZodString>;
            /** Name of a package to look up */
            package: z.ZodOptional<z.ZodString>;
            /** Whether the dependency is inherited from the workspace */
            workspace: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>, PackageDependency<CargoManagerData>, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>, z.ZodEffects<z.ZodString, PackageDependency<CargoManagerData>, string>]>>, PackageDependency<Record<string, any>>[], Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>>, PackageDependency<Record<string, any>>[], Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>>>;
        'dev-dependencies': z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodEffects<z.ZodObject<{
            /** Path on disk to the crate sources */
            path: z.ZodOptional<z.ZodString>;
            /** Git URL for the dependency */
            git: z.ZodOptional<z.ZodString>;
            /** Semver version */
            version: z.ZodOptional<z.ZodString>;
            /** Name of a registry whose URL is configured in `.cargo/config.toml` or `.cargo/config` */
            registry: z.ZodOptional<z.ZodString>;
            /** Name of a package to look up */
            package: z.ZodOptional<z.ZodString>;
            /** Whether the dependency is inherited from the workspace */
            workspace: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>, PackageDependency<CargoManagerData>, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>, z.ZodEffects<z.ZodString, PackageDependency<CargoManagerData>, string>]>>, PackageDependency<Record<string, any>>[], Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>>, PackageDependency<Record<string, any>>[], Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>>>;
        'build-dependencies': z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodEffects<z.ZodObject<{
            /** Path on disk to the crate sources */
            path: z.ZodOptional<z.ZodString>;
            /** Git URL for the dependency */
            git: z.ZodOptional<z.ZodString>;
            /** Semver version */
            version: z.ZodOptional<z.ZodString>;
            /** Name of a registry whose URL is configured in `.cargo/config.toml` or `.cargo/config` */
            registry: z.ZodOptional<z.ZodString>;
            /** Name of a package to look up */
            package: z.ZodOptional<z.ZodString>;
            /** Whether the dependency is inherited from the workspace */
            workspace: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>, PackageDependency<CargoManagerData>, {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>, z.ZodEffects<z.ZodString, PackageDependency<CargoManagerData>, string>]>>, PackageDependency<Record<string, any>>[], Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>>, PackageDependency<Record<string, any>>[], Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        dependencies?: PackageDependency<Record<string, any>>[] | undefined;
        'dev-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
        'build-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
    }, {
        dependencies?: Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }> | undefined;
        'dev-dependencies'?: Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }> | undefined;
        'build-dependencies'?: Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }> | undefined;
    }>>>;
}, "strip", z.ZodTypeAny, {
    package?: {
        version?: string | {
            workspace: true;
        } | undefined;
    } | undefined;
    target?: Record<string, {
        dependencies?: PackageDependency<Record<string, any>>[] | undefined;
        'dev-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
        'build-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
    }> | undefined;
    dependencies?: PackageDependency<Record<string, any>>[] | undefined;
    workspace?: {
        package?: {
            version?: string | undefined;
        } | undefined;
        dependencies?: PackageDependency<Record<string, any>>[] | undefined;
    } | undefined;
    'dev-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
    'build-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
}, {
    package?: {
        version?: string | {
            workspace: true;
        } | undefined;
    } | undefined;
    target?: Record<string, {
        dependencies?: Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }> | undefined;
        'dev-dependencies'?: Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }> | undefined;
        'build-dependencies'?: Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }> | undefined;
    }> | undefined;
    dependencies?: Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }> | undefined;
    workspace?: {
        package?: {
            version?: string | undefined;
        } | undefined;
        dependencies?: Record<string, string | {
            path?: string | undefined;
            version?: string | undefined;
            git?: string | undefined;
            package?: string | undefined;
            registry?: string | undefined;
            workspace?: boolean | undefined;
        }> | undefined;
    } | undefined;
    'dev-dependencies'?: Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }> | undefined;
    'build-dependencies'?: Record<string, string | {
        path?: string | undefined;
        version?: string | undefined;
        git?: string | undefined;
        package?: string | undefined;
        registry?: string | undefined;
        workspace?: boolean | undefined;
    }> | undefined;
}>>;
export declare const CargoConfigSchema: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    registries: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        index: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        index?: string | undefined;
    }, {
        index?: string | undefined;
    }>>>;
    source: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        'replace-with': z.ZodOptional<z.ZodString>;
        registry: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        registry?: string | undefined;
        'replace-with'?: string | undefined;
    }, {
        registry?: string | undefined;
        'replace-with'?: string | undefined;
    }>>>;
}, "strip", z.ZodTypeAny, {
    source?: Record<string, {
        registry?: string | undefined;
        'replace-with'?: string | undefined;
    }> | undefined;
    registries?: Record<string, {
        index?: string | undefined;
    }> | undefined;
}, {
    source?: Record<string, {
        registry?: string | undefined;
        'replace-with'?: string | undefined;
    }> | undefined;
    registries?: Record<string, {
        index?: string | undefined;
    }> | undefined;
}>>;
export type CargoConfig = z.infer<typeof CargoConfigSchema>;
export declare const CargoLockSchema: z.ZodObject<{
    package: z.ZodOptional<z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        version: z.ZodString;
        source: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        source?: string | undefined;
    }, {
        name: string;
        version: string;
        source?: string | undefined;
    }>, "many">>;
}, "strip", z.ZodTypeAny, {
    package?: {
        name: string;
        version: string;
        source?: string | undefined;
    }[] | undefined;
}, {
    package?: {
        name: string;
        version: string;
        source?: string | undefined;
    }[] | undefined;
}>;
export type CargoLockSchema = z.infer<typeof CargoLockSchema>;
export declare const CargoLockSchemaToml: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    package: z.ZodOptional<z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        version: z.ZodString;
        source: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        source?: string | undefined;
    }, {
        name: string;
        version: string;
        source?: string | undefined;
    }>, "many">>;
}, "strip", z.ZodTypeAny, {
    package?: {
        name: string;
        version: string;
        source?: string | undefined;
    }[] | undefined;
}, {
    package?: {
        name: string;
        version: string;
        source?: string | undefined;
    }[] | undefined;
}>>;
export {};
