"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractLockFileVersions = extractLockFileVersions;
exports.extractLockFileContentVersions = extractLockFileContentVersions;
exports.parseLockFile = parseLockFile;
const logger_1 = require("../../../logger");
const array_1 = require("../../../util/array");
const fs_1 = require("../../../util/fs");
const schema_1 = require("./schema");
async function extractLockFileVersions(lockFilePath) {
    const content = await (0, fs_1.readLocalFile)(lockFilePath, 'utf8');
    if (content) {
        return extractLockFileContentVersions(content);
    }
    return null;
}
function extractLockFileContentVersions(content) {
    const versionsByPackage = new Map();
    const lock = parseLockFile(content);
    if (!lock) {
        return null;
    }
    for (const pkg of (0, array_1.coerceArray)(lock.package)) {
        const versions = (0, array_1.coerceArray)(versionsByPackage.get(pkg.name));
        versions.push(pkg.version);
        versionsByPackage.set(pkg.name, versions);
    }
    return versionsByPackage;
}
function parseLockFile(lockFile) {
    const res = schema_1.CargoLockSchemaToml.safeParse(lockFile);
    if (res.success) {
        return res.data;
    }
    logger_1.logger.debug({ err: res.error }, 'Error parsing Cargo lockfile.');
    return null;
}
//# sourceMappingURL=locked-version.js.map