"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = void 0;
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const moo_1 = tslib_1.__importDefault(require("moo"));
const regex_1 = require("../../../util/regex");
const url_1 = require("../../../util/url");
const nuget_1 = require("../../datasource/nuget");
exports.url = 'https://cakebuild.net/docs';
exports.categories = ['dotnet'];
exports.defaultConfig = {
    managerFilePatterns: ['/\\.cake$/'],
};
exports.supportedDatasources = [nuget_1.NugetDatasource.id];
const lexer = moo_1.default.states({
    main: {
        lineComment: { match: /\/\/.*?$/ }, // TODO #12870
        multiLineComment: { match: /\/\*[^]*?\*\//, lineBreaks: true }, // TODO #12870
        dependency: {
            match: /^#(?:addin|tool|module|load|l)\s+(?:nuget|dotnet):.*$/, // TODO #12870
        },
        dependencyQuoted: {
            match: /^#(?:addin|tool|module|load|l)\s+"(?:nuget|dotnet):[^"]+"\s*$/, // TODO #12870
            value: (s) => s.trim().slice(1, -1),
        },
        unknown: moo_1.default.fallback,
    },
});
function parseDependencyLine(line) {
    try {
        let url = line.replace((0, regex_1.regEx)(/^[^:]*:/), '');
        const isEmptyHost = url.startsWith('?');
        url = isEmptyHost ? `http://localhost/${url}` : url;
        const parsedUrl = new URL(url);
        const { origin, pathname, searchParams } = parsedUrl;
        const registryUrl = `${origin}${pathname}`;
        const depName = searchParams.get('package');
        const currentValue = searchParams.get('version') ?? undefined;
        const result = {
            datasource: nuget_1.NugetDatasource.id,
            depName,
            currentValue,
        };
        if (!isEmptyHost) {
            if ((0, url_1.isHttpUrl)(parsedUrl)) {
                result.registryUrls = [registryUrl];
            }
            else {
                result.skipReason = 'unsupported-url';
            }
        }
        return result;
    }
    catch {
        return null;
    }
}
function extractPackageFile(content) {
    const deps = [];
    lexer.reset(content);
    let token = lexer.next();
    while (token) {
        const { type, value } = token;
        if (type === 'dependency' || type === 'dependencyQuoted') {
            const dep = parseDependencyLine(value);
            if (dep) {
                deps.push(dep);
            }
        }
        token = lexer.next();
    }
    return { deps };
}
//# sourceMappingURL=index.js.map