"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateLockedDependency = updateLockedDependency;
const logger_1 = require("../../../logger");
const locked_version_1 = require("./locked-version");
function updateLockedDependency(config) {
    const { depName, currentVersion, newVersion, lockFile, lockFileContent } = config;
    logger_1.logger.debug(`bundler.updateLockedDependency: ${depName}@${currentVersion} -> ${newVersion} [${lockFile}]`);
    try {
        const locked = (0, locked_version_1.extractLockFileEntries)(lockFileContent ?? '');
        if (locked.get(depName ?? '') === newVersion) {
            return { status: 'already-updated' };
        }
        return { status: 'unsupported' };
    }
    catch (err) {
        logger_1.logger.debug({ err }, 'bundler.updateLockedDependency() error');
        return { status: 'update-failed' };
    }
}
//# sourceMappingURL=update-locked.js.map