"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findAllAuthenticatable = findAllAuthenticatable;
exports.getAuthenticationHeaderValue = getAuthenticationHeaderValue;
const host_rules_1 = require("../../../util/host-rules");
function isAuthenticatable(rule) {
    return (!!rule.resolvedHost &&
        ((!!rule.username && !!rule.password) || !!rule.token));
}
function findAllAuthenticatable({ hostType, }) {
    return (0, host_rules_1.findAll)({ hostType }).filter(isAuthenticatable);
}
function getAuthenticationHeaderValue(hostRule) {
    if (hostRule.username) {
        const username = encodeURIComponent(hostRule.username);
        // TODO: types (#22198)
        return `${username}:${hostRule.password}`;
    }
    // TODO: types (#22198)
    return `${hostRule.token}`;
}
//# sourceMappingURL=host-rules.js.map