"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.extractPackageFile = void 0;
const bitbucket_tags_1 = require("../../datasource/bitbucket-tags");
const github_tags_1 = require("../../datasource/github-tags");
const extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.url = 'https://buildkite.com/docs';
exports.categories = ['ci'];
exports.defaultConfig = {
    managerFilePatterns: ['/buildkite\\.ya?ml/', '/\\.buildkite/.+\\.ya?ml$/'],
    commitMessageTopic: 'buildkite plugin {{depName}}',
    commitMessageExtra: 'to {{#if isMajor}}{{{prettyNewMajor}}}{{else}}{{{newValue}}}{{/if}}',
};
exports.supportedDatasources = [
    github_tags_1.GithubTagsDatasource.id,
    bitbucket_tags_1.BitbucketTagsDatasource.id,
];
//# sourceMappingURL=index.js.map