"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitriseFile = void 0;
const zod_1 = require("zod");
const filter_map_1 = require("../../../util/filter-map");
const schema_utils_1 = require("../../../util/schema-utils");
const utils_1 = require("./utils");
exports.BitriseFile = schema_utils_1.Yaml.pipe(zod_1.z
    .object({
    default_step_lib_source: zod_1.z.string().optional(),
    workflows: zod_1.z
        .record(zod_1.z
        .object({
        steps: zod_1.z
            .array(zod_1.z.record(zod_1.z.unknown()).transform((x) => Object.keys(x)))
            .transform((steps) => steps.flat()),
    })
        .transform(({ steps }) => steps))
        .transform((x) => Object.values(x).flat()),
})
    .transform(({ default_step_lib_source: defaultRegistry, workflows }) => (0, filter_map_1.filterMap)(workflows, (workflow) => (0, utils_1.parseStep)(workflow, defaultRegistry))));
//# sourceMappingURL=schema.js.map