"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const schema_1 = require("./schema");
function extractPackageFile(content, packageFile) {
    const deps = schema_1.BitriseFile.catch(({ error: err }) => {
        logger_1.logger.debug({ err, packageFile }, `Failed to parse Bitrise YAML config`);
        return [];
    }).parse(content);
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map