"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dockerImageObjectRegex = exports.dockerImageRegex = exports.pipeRegex = void 0;
exports.addDepAsBitbucketTag = addDepAsBitbucketTag;
exports.addDepAsDockerImage = addDepAsDockerImage;
exports.addDepFromObject = addDepFromObject;
const regex_1 = require("../../../util/regex");
const bitbucket_tags_1 = require("../../datasource/bitbucket-tags");
const extract_1 = require("../dockerfile/extract");
exports.pipeRegex = (0, regex_1.regEx)(`^\\s*-\\s?pipe:\\s*'?"?([^\\s'"]+)'?"?\\s*$`);
exports.dockerImageRegex = (0, regex_1.regEx)(`^\\s*-?\\s?image:\\s*'?"?([^\\s'"]+)'?"?\\s*$`);
exports.dockerImageObjectRegex = (0, regex_1.regEx)('^(?<spaces>\\s*)image:\\s*$');
function addDepAsBitbucketTag(deps, pipe) {
    const [depName, currentValue] = pipe.split(':');
    const dep = {
        depName,
        currentValue,
        datasource: bitbucket_tags_1.BitbucketTagsDatasource.id,
    };
    dep.depType = 'bitbucket-tags';
    deps.push(dep);
}
function addDepAsDockerImage(deps, currentDockerImage, registryAliases) {
    const dep = (0, extract_1.getDep)(currentDockerImage, true, registryAliases);
    dep.depType = 'docker';
    deps.push(dep);
}
function addDepFromObject(deps, lines, start, len, spaces, registryAliases) {
    const nameRegex = (0, regex_1.regEx)(`^${spaces}\\s+name:\\s*['"]?(?<image>[^\\s'"]+)['"]?\\s*$`);
    const indentRegex = (0, regex_1.regEx)(`^${spaces}\\s+`);
    for (let idx = start + 1; idx < len; idx++) {
        const line = lines[idx];
        if (!indentRegex.test(line)) {
            // malformed
            return idx;
        }
        const groups = nameRegex.exec(line)?.groups;
        if (groups) {
            const dep = (0, extract_1.getDep)(groups.image, true, registryAliases);
            dep.depType = 'docker';
            deps.push(dep);
            return idx;
        }
    }
    // malformed
    return start;
}
//# sourceMappingURL=util.js.map