"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const regex_1 = require("../../../util/regex");
const azure_bicep_resource_1 = require("../../datasource/azure-bicep-resource");
const RESOURCE_REGEX = (0, regex_1.regEx)(/resource\s+[A-Za-z0-9_]+\s+(?<replaceString>'(?<depName>.+\..+\/.+)@(?<currentValue>.+?)')/);
function extractPackageFile(content, _packageFile, _config) {
    const deps = [];
    for (const line of content.split(regex_1.newlineRegex)) {
        const trimmedLine = line?.trim();
        if (!trimmedLine || trimmedLine.startsWith('//')) {
            continue;
        }
        const match = RESOURCE_REGEX.exec(trimmedLine);
        if (!match?.groups) {
            continue;
        }
        const { depName, currentValue, replaceString } = match.groups;
        deps.push({
            datasource: azure_bicep_resource_1.AzureBicepResourceDatasource.id,
            versioning: 'azure-rest-api',
            depName,
            currentValue,
            autoReplaceStringTemplate: "'{{depName}}@{{newValue}}'",
            replaceString,
        });
    }
    return Promise.resolve(deps.length ? { deps } : null);
}
//# sourceMappingURL=extract.js.map