"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenTarget = exports.mavenRules = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const zod_1 = require("zod");
const maven_1 = require("../../../datasource/maven");
const gradle_1 = require("../../../versioning/gradle");
exports.mavenRules = ['maven_install', '_maven_install'];
const ArtifactSpec = zod_1.z.union([
    zod_1.z.object({
        group: zod_1.z.string(),
        artifact: zod_1.z.string(),
        version: zod_1.z.string(),
    }),
    zod_1.z
        .object({
        '0': zod_1.z.string(),
        '1': zod_1.z.string(),
        '2': zod_1.z.string(),
    })
        .transform((x) => ({ group: x[0], artifact: x[1], version: x[2] })),
]);
exports.MavenTarget = zod_1.z
    .object({
    rule: zod_1.z.enum(exports.mavenRules),
    artifacts: zod_1.z
        .union([zod_1.z.string(), ArtifactSpec])
        .array()
        .transform((xs) => {
        const result = [];
        for (const x of xs) {
            if (is_1.default.string(x)) {
                const [group, artifact, version] = x.split(':');
                if (group && artifact && version) {
                    result.push({ group, artifact, version });
                }
            }
            else {
                result.push(x);
            }
        }
        return result;
    }),
    repositories: zod_1.z.array(zod_1.z.string()).optional(),
})
    .transform(({ rule: depType, artifacts, repositories: registryUrls, }) => artifacts.map(({ group, artifact, version: currentValue }) => ({
    datasource: maven_1.MavenDatasource.id,
    versioning: gradle_1.id,
    depName: `${group}:${artifact}`,
    currentValue,
    depType,
    registryUrls,
})));
//# sourceMappingURL=maven.js.map