import { z } from 'zod';
import type { PackageDependency } from '../../types';
export declare const mavenRules: readonly ["maven_install", "_maven_install"];
export declare const MavenTarget: z.ZodEffects<z.ZodObject<{
    rule: z.ZodEnum<["maven_install", "_maven_install"]>;
    artifacts: z.ZodEffects<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodUnion<[z.ZodObject<{
        group: z.ZodString;
        artifact: z.ZodString;
        version: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        version: string;
        artifact: string;
        group: string;
    }, {
        version: string;
        artifact: string;
        group: string;
    }>, z.ZodEffects<z.ZodObject<{
        '0': z.ZodString;
        '1': z.ZodString;
        '2': z.ZodString;
    }, "strip", z.ZodTypeAny, {
        '0': string;
        '1': string;
        '2': string;
    }, {
        '0': string;
        '1': string;
        '2': string;
    }>, {
        group: string;
        artifact: string;
        version: string;
    }, {
        '0': string;
        '1': string;
        '2': string;
    }>]>]>, "many">, ({
        version: string;
        artifact: string;
        group: string;
    } | {
        group: string;
        artifact: string;
        version: string;
    })[], (string | {
        version: string;
        artifact: string;
        group: string;
    } | {
        '0': string;
        '1': string;
        '2': string;
    })[]>;
    repositories: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    rule: "maven_install" | "_maven_install";
    artifacts: ({
        version: string;
        artifact: string;
        group: string;
    } | {
        group: string;
        artifact: string;
        version: string;
    })[];
    repositories?: string[] | undefined;
}, {
    rule: "maven_install" | "_maven_install";
    artifacts: (string | {
        version: string;
        artifact: string;
        group: string;
    } | {
        '0': string;
        '1': string;
        '2': string;
    })[];
    repositories?: string[] | undefined;
}>, PackageDependency<Record<string, any>>[], {
    rule: "maven_install" | "_maven_install";
    artifacts: (string | {
        version: string;
        artifact: string;
        group: string;
    } | {
        '0': string;
        '1': string;
        '2': string;
    })[];
    repositories?: string[] | undefined;
}>;
