"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoTarget = exports.goRules = void 0;
const zod_1 = require("zod");
const regex_1 = require("../../../../util/regex");
const go_1 = require("../../../datasource/go");
exports.goRules = ['go_repository', '_go_repository'];
exports.GoTarget = zod_1.z
    .object({
    rule: zod_1.z.enum(exports.goRules),
    name: zod_1.z.string(),
    tag: zod_1.z.string().optional(),
    commit: zod_1.z.string().optional(),
    importpath: zod_1.z.string(),
    remote: zod_1.z.string().optional(),
})
    .refine(({ tag, commit }) => !!tag || !!commit)
    .transform(({ rule, name, tag, commit, importpath, remote }) => {
    const dep = {
        datasource: go_1.GoDatasource.id,
        depType: rule,
        depName: name,
        packageName: importpath,
    };
    if (tag) {
        dep.currentValue = tag;
    }
    if (commit) {
        dep.currentDigest = commit;
        if (!tag) {
            dep.digestOneAndOnly = true;
        }
    }
    if (remote) {
        const remoteMatch = (0, regex_1.regEx)(/https:\/\/github\.com(?:.*\/)(([a-zA-Z]+)([-])?([a-zA-Z]+))/).exec(remote);
        if (remoteMatch && remoteMatch[0].length === remote.length) {
            dep.packageName = remote.replace('https://', '');
        }
        else {
            dep.skipReason = 'unsupported-remote';
        }
    }
    return [dep];
});
//# sourceMappingURL=go.js.map