"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.booleanStringValues = void 0;
exports.asBoolean = asBoolean;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const stringMapping = new Map([
    ['True', true],
    ['False', false],
]);
exports.booleanStringValues = Array.from(stringMapping.keys());
function asBoolean(value) {
    const result = stringMapping.get(value);
    if (is_1.default.boolean(result)) {
        return result;
    }
    throw new Error(`Invalid Starlark boolean string: ${value}`);
}
//# sourceMappingURL=starlark.js.map