"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleToDockerPackageDep = exports.ociExtensionTags = exports.ociExtensionPrefix = void 0;
const zod_1 = require("zod");
const docker_1 = require("../../../datasource/docker");
const fragments_1 = require("./fragments");
exports.ociExtensionPrefix = 'oci';
const pullTag = 'pull';
exports.ociExtensionTags = ['pull'];
exports.RuleToDockerPackageDep = fragments_1.ExtensionTagFragmentSchema.extend({
    extension: zod_1.z.literal(exports.ociExtensionPrefix),
    tag: zod_1.z.literal(pullTag),
    children: zod_1.z.object({
        name: fragments_1.StringFragmentSchema,
        image: fragments_1.StringFragmentSchema,
        tag: fragments_1.StringFragmentSchema.optional(),
        digest: fragments_1.StringFragmentSchema.optional(),
    }),
}).transform(({ rawString, children: { name, image, tag, digest }, }) => ({
    datasource: docker_1.DockerDatasource.id,
    depType: 'oci_pull',
    depName: name.value,
    packageName: image.value,
    currentValue: tag?.value,
    currentDigest: digest?.value,
    // Provide a replace string so the auto replacer can replace both the tag
    // and digest if applicable.
    replaceString: rawString,
}));
//# sourceMappingURL=oci.js.map