"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AllFragmentsSchema = exports.AttributeFragmentSchema = exports.ExtensionTagFragmentSchema = exports.PreparedExtensionTagFragmentSchema = exports.RuleFragmentSchema = exports.StringArrayFragmentSchema = exports.ArrayFragmentSchema = exports.BooleanFragmentSchema = exports.StringFragmentSchema = void 0;
exports.string = string;
exports.boolean = boolean;
exports.rule = rule;
exports.preparedExtensionTag = preparedExtensionTag;
exports.extensionTag = extensionTag;
exports.attribute = attribute;
exports.array = array;
exports.isValue = isValue;
exports.isPrimitive = isPrimitive;
const tslib_1 = require("tslib");
const zod_1 = require("zod");
const schema_utils_1 = require("../../../../util/schema-utils");
const starlark = tslib_1.__importStar(require("./starlark"));
exports.StringFragmentSchema = zod_1.z.object({
    type: zod_1.z.literal('string'),
    value: zod_1.z.string(),
    isComplete: zod_1.z.literal(true),
});
exports.BooleanFragmentSchema = zod_1.z.object({
    type: zod_1.z.literal('boolean'),
    value: zod_1.z.boolean(),
    isComplete: zod_1.z.literal(true),
});
const PrimitiveFragmentsSchema = zod_1.z.discriminatedUnion('type', [
    exports.StringFragmentSchema,
    exports.BooleanFragmentSchema,
]);
exports.ArrayFragmentSchema = zod_1.z.object({
    type: zod_1.z.literal('array'),
    items: (0, schema_utils_1.LooseArray)(PrimitiveFragmentsSchema),
    isComplete: zod_1.z.boolean(),
});
exports.StringArrayFragmentSchema = zod_1.z.object({
    type: zod_1.z.literal('array'),
    items: (0, schema_utils_1.LooseArray)(exports.StringFragmentSchema),
    isComplete: zod_1.z.boolean(),
});
const ValueFragmentsSchema = zod_1.z.discriminatedUnion('type', [
    exports.StringFragmentSchema,
    exports.BooleanFragmentSchema,
    exports.ArrayFragmentSchema,
]);
exports.RuleFragmentSchema = zod_1.z.object({
    type: zod_1.z.literal('rule'),
    rule: zod_1.z.string(),
    children: (0, schema_utils_1.LooseRecord)(ValueFragmentsSchema),
    isComplete: zod_1.z.boolean(),
});
exports.PreparedExtensionTagFragmentSchema = zod_1.z.object({
    type: zod_1.z.literal('preparedExtensionTag'),
    // See ExtensionTagFragmentSchema for documentation of the fields.
    extension: zod_1.z.string(),
    rawExtension: zod_1.z.string(),
    offset: zod_1.z.number(), // start offset in the source string
    isComplete: zod_1.z.literal(false), // never complete, parser internal type.
});
exports.ExtensionTagFragmentSchema = zod_1.z.object({
    type: zod_1.z.literal('extensionTag'),
    // The "logical" name of the extension (e.g. `oci` or `maven`).
    extension: zod_1.z.string(),
    // The "raw" name of the extension as it appears in the MODULE file (e.g. `maven_01` or `maven`)
    rawExtension: zod_1.z.string(),
    tag: zod_1.z.string(),
    children: (0, schema_utils_1.LooseRecord)(ValueFragmentsSchema),
    isComplete: zod_1.z.boolean(),
    offset: zod_1.z.number(), // start offset in the source string
    rawString: zod_1.z.string().optional(), // raw source string
});
exports.AttributeFragmentSchema = zod_1.z.object({
    type: zod_1.z.literal('attribute'),
    name: zod_1.z.string(),
    value: ValueFragmentsSchema.optional(),
    isComplete: zod_1.z.boolean(),
});
exports.AllFragmentsSchema = zod_1.z.discriminatedUnion('type', [
    exports.ArrayFragmentSchema,
    exports.AttributeFragmentSchema,
    exports.BooleanFragmentSchema,
    exports.RuleFragmentSchema,
    exports.PreparedExtensionTagFragmentSchema,
    exports.ExtensionTagFragmentSchema,
    exports.StringFragmentSchema,
]);
function string(value) {
    return {
        type: 'string',
        isComplete: true,
        value,
    };
}
function boolean(value) {
    return {
        type: 'boolean',
        isComplete: true,
        value: typeof value === 'string' ? starlark.asBoolean(value) : value,
    };
}
function rule(rule, children = {}, isComplete = false) {
    return {
        type: 'rule',
        rule,
        isComplete,
        children,
    };
}
function preparedExtensionTag(extension, rawExtension, offset) {
    return {
        type: 'preparedExtensionTag',
        extension,
        rawExtension,
        offset,
        isComplete: false, // never complete
    };
}
function extensionTag(extension, rawExtension, tag, offset, children = {}, rawString, isComplete = false) {
    return {
        type: 'extensionTag',
        extension,
        rawExtension,
        tag,
        offset,
        rawString,
        isComplete,
        children,
    };
}
function attribute(name, value, isComplete = false) {
    return {
        type: 'attribute',
        name,
        value,
        isComplete,
    };
}
function array(items = [], isComplete = false) {
    return {
        type: 'array',
        items,
        isComplete,
    };
}
function isValue(data) {
    const result = ValueFragmentsSchema.safeParse(data);
    return result.success;
}
function isPrimitive(data) {
    const result = PrimitiveFragmentsSchema.safeParse(data);
    return result.success;
}
//# sourceMappingURL=fragments.js.map