import type { AllFragments, ResultFragment } from './fragments';
export interface CtxCompatible {
    results: ResultFragment[];
    stack: AllFragments[];
}
export declare class CtxProcessingError extends Error {
    readonly current: AllFragments;
    readonly parent?: AllFragments;
    constructor(current: AllFragments, parent?: AllFragments);
}
export declare class Ctx implements CtxCompatible {
    readonly source: string;
    results: ResultFragment[];
    stack: AllFragments[];
    constructor(source: string);
    private get safeCurrent();
    private get current();
    private get currentRule();
    private get currentExtensionTag();
    private get currentArray();
    private popPreparedExtensionTag;
    private popStack;
    private processStack;
    addString(value: string): Ctx;
    addBoolean(value: string | boolean): Ctx;
    startRule(name: string): Ctx;
    endRule(): Ctx;
    prepareExtensionTag(extension: string, rawExtension: string, offset: number): Ctx;
    startExtensionTag(tag: string): Ctx;
    endExtensionTag(offset: number): Ctx;
    startAttribute(name: string): Ctx;
    startArray(): Ctx;
    endArray(): Ctx;
}
