"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.extractPackageFile = void 0;
const bazel_1 = require("../../datasource/bazel");
const docker_1 = require("../../datasource/docker");
const github_tags_1 = require("../../datasource/github-tags");
const maven_1 = require("../../datasource/maven");
const extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.url = 'https://bazel.build/external/module';
exports.categories = ['bazel'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/|\\.)MODULE\\.bazel$/'],
};
exports.supportedDatasources = [
    bazel_1.BazelDatasource.id,
    docker_1.DockerDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    maven_1.MavenDatasource.id,
];
//# sourceMappingURL=index.js.map