"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatectConfigSchema = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const git_tags_1 = require("../../datasource/git-tags");
const semver_1 = require("../../versioning/semver");
const extract_1 = require("../dockerfile/extract");
exports.BatectConfigSchema = schema_utils_1.Yaml.pipe(zod_1.z.object({
    containers: (0, schema_utils_1.LooseRecord)(zod_1.z.string(), zod_1.z.object({ image: zod_1.z.string() }).transform(({ image }) => image))
        .transform((x) => Object.values(x))
        .catch([]),
    include: (0, schema_utils_1.LooseArray)(zod_1.z.union([
        zod_1.z.object({
            type: zod_1.z.literal('git'),
            repo: zod_1.z.string(),
            ref: zod_1.z.string(),
        }),
        zod_1.z.object({
            type: zod_1.z.literal('file'),
            path: zod_1.z.string(),
        }),
        zod_1.z.string().transform((path) => ({ type: 'file', path })),
    ])).catch([]),
})).transform(({ containers, include }) => {
    // TODO: @zharinov How to pass `registryAliases` to `getDep`?
    const imageDependencies = containers.map((image) => (0, extract_1.getDep)(image));
    const bundleDependencies = [];
    const fileIncludes = [];
    for (const item of include) {
        if (item.type === 'git') {
            bundleDependencies.push({
                depName: item.repo,
                currentValue: item.ref,
                versioning: semver_1.id,
                datasource: git_tags_1.GitTagsDatasource.id,
                commitMessageTopic: 'bundle {{depName}}',
            });
        }
        else {
            fileIncludes.push(item.path);
        }
    }
    return {
        imageDependencies,
        bundleDependencies,
        fileIncludes,
    };
});
//# sourceMappingURL=schema.js.map