"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.extractPackageFile = exports.extractAllPackageFiles = void 0;
const docker_1 = require("../../datasource/docker");
const git_tags_1 = require("../../datasource/git-tags");
const extract_1 = require("./extract");
Object.defineProperty(exports, "extractAllPackageFiles", { enumerable: true, get: function () { return extract_1.extractAllPackageFiles; } });
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.url = 'https://batect.dev/docs';
exports.categories = ['batect'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)batect(-bundle)?\\.ya?ml$/'],
};
exports.supportedDatasources = [docker_1.DockerDatasource.id, git_tags_1.GitTagsDatasource.id];
//# sourceMappingURL=index.js.map