"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AzurePipelinesYaml = exports.AzurePipelines = exports.Resources = exports.Repository = exports.Container = exports.Stage = exports.Jobs = exports.Deployment = exports.Deploy = exports.Job = exports.Step = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
exports.Step = zod_1.z.object({
    task: zod_1.z.string(),
});
exports.Job = zod_1.z.object({
    steps: (0, schema_utils_1.LooseArray)(exports.Step),
});
exports.Deploy = zod_1.z
    .object({
    deploy: exports.Job,
    preDeploy: exports.Job,
    routeTraffic: exports.Job,
    postRouteTraffic: exports.Job,
    on: zod_1.z
        .object({
        failure: exports.Job,
        success: exports.Job,
    })
        .partial(),
})
    .partial();
exports.Deployment = zod_1.z
    .object({
    strategy: zod_1.z
        .object({
        runOnce: exports.Deploy,
        rolling: exports.Deploy,
        canary: exports.Deploy,
    })
        .partial(),
})
    .partial();
exports.Jobs = (0, schema_utils_1.LooseArray)(zod_1.z.union([exports.Job, exports.Deployment]));
exports.Stage = zod_1.z.object({
    jobs: exports.Jobs,
});
exports.Container = zod_1.z.object({
    image: zod_1.z.string(),
});
exports.Repository = zod_1.z.object({
    type: zod_1.z.enum(['git', 'github', 'bitbucket']),
    name: zod_1.z.string(),
    ref: zod_1.z.string().optional(),
});
exports.Resources = zod_1.z
    .object({
    repositories: (0, schema_utils_1.LooseArray)(exports.Repository),
    containers: (0, schema_utils_1.LooseArray)(exports.Container),
})
    .partial();
exports.AzurePipelines = zod_1.z
    .object({
    resources: exports.Resources,
    stages: (0, schema_utils_1.LooseArray)(exports.Stage),
    jobs: exports.Jobs,
    steps: (0, schema_utils_1.LooseArray)(exports.Step),
})
    .partial();
exports.AzurePipelinesYaml = schema_utils_1.Yaml.pipe(exports.AzurePipelines);
//# sourceMappingURL=schema.js.map