import { z } from 'zod';
export declare const Step: z.ZodObject<{
    task: z.ZodString;
}, "strip", z.ZodTypeAny, {
    task: string;
}, {
    task: string;
}>;
export type Step = z.infer<typeof Step>;
export declare const Job: z.ZodObject<{
    steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        task: string;
    }[], any[]>;
}, "strip", z.ZodTypeAny, {
    steps: {
        task: string;
    }[];
}, {
    steps: any[];
}>;
export type Job = z.infer<typeof Job>;
export declare const Deploy: z.ZodObject<{
    deploy: z.ZodOptional<z.ZodObject<{
        steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            task: string;
        }[], any[]>;
    }, "strip", z.ZodTypeAny, {
        steps: {
            task: string;
        }[];
    }, {
        steps: any[];
    }>>;
    preDeploy: z.ZodOptional<z.ZodObject<{
        steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            task: string;
        }[], any[]>;
    }, "strip", z.ZodTypeAny, {
        steps: {
            task: string;
        }[];
    }, {
        steps: any[];
    }>>;
    routeTraffic: z.ZodOptional<z.ZodObject<{
        steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            task: string;
        }[], any[]>;
    }, "strip", z.ZodTypeAny, {
        steps: {
            task: string;
        }[];
    }, {
        steps: any[];
    }>>;
    postRouteTraffic: z.ZodOptional<z.ZodObject<{
        steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            task: string;
        }[], any[]>;
    }, "strip", z.ZodTypeAny, {
        steps: {
            task: string;
        }[];
    }, {
        steps: any[];
    }>>;
    on: z.ZodOptional<z.ZodObject<{
        failure: z.ZodOptional<z.ZodObject<{
            steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                task: string;
            }[], any[]>;
        }, "strip", z.ZodTypeAny, {
            steps: {
                task: string;
            }[];
        }, {
            steps: any[];
        }>>;
        success: z.ZodOptional<z.ZodObject<{
            steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                task: string;
            }[], any[]>;
        }, "strip", z.ZodTypeAny, {
            steps: {
                task: string;
            }[];
        }, {
            steps: any[];
        }>>;
    }, "strip", z.ZodTypeAny, {
        success?: {
            steps: {
                task: string;
            }[];
        } | undefined;
        failure?: {
            steps: {
                task: string;
            }[];
        } | undefined;
    }, {
        success?: {
            steps: any[];
        } | undefined;
        failure?: {
            steps: any[];
        } | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    on?: {
        success?: {
            steps: {
                task: string;
            }[];
        } | undefined;
        failure?: {
            steps: {
                task: string;
            }[];
        } | undefined;
    } | undefined;
    deploy?: {
        steps: {
            task: string;
        }[];
    } | undefined;
    preDeploy?: {
        steps: {
            task: string;
        }[];
    } | undefined;
    routeTraffic?: {
        steps: {
            task: string;
        }[];
    } | undefined;
    postRouteTraffic?: {
        steps: {
            task: string;
        }[];
    } | undefined;
}, {
    on?: {
        success?: {
            steps: any[];
        } | undefined;
        failure?: {
            steps: any[];
        } | undefined;
    } | undefined;
    deploy?: {
        steps: any[];
    } | undefined;
    preDeploy?: {
        steps: any[];
    } | undefined;
    routeTraffic?: {
        steps: any[];
    } | undefined;
    postRouteTraffic?: {
        steps: any[];
    } | undefined;
}>;
export type Deploy = z.infer<typeof Deploy>;
export declare const Deployment: z.ZodObject<{
    strategy: z.ZodOptional<z.ZodObject<{
        runOnce: z.ZodOptional<z.ZodObject<{
            deploy: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            preDeploy: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            routeTraffic: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            postRouteTraffic: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            on: z.ZodOptional<z.ZodObject<{
                failure: z.ZodOptional<z.ZodObject<{
                    steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                        task: string;
                    }[], any[]>;
                }, "strip", z.ZodTypeAny, {
                    steps: {
                        task: string;
                    }[];
                }, {
                    steps: any[];
                }>>;
                success: z.ZodOptional<z.ZodObject<{
                    steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                        task: string;
                    }[], any[]>;
                }, "strip", z.ZodTypeAny, {
                    steps: {
                        task: string;
                    }[];
                }, {
                    steps: any[];
                }>>;
            }, "strip", z.ZodTypeAny, {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            }, {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        }, {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        }>>;
        rolling: z.ZodOptional<z.ZodObject<{
            deploy: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            preDeploy: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            routeTraffic: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            postRouteTraffic: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            on: z.ZodOptional<z.ZodObject<{
                failure: z.ZodOptional<z.ZodObject<{
                    steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                        task: string;
                    }[], any[]>;
                }, "strip", z.ZodTypeAny, {
                    steps: {
                        task: string;
                    }[];
                }, {
                    steps: any[];
                }>>;
                success: z.ZodOptional<z.ZodObject<{
                    steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                        task: string;
                    }[], any[]>;
                }, "strip", z.ZodTypeAny, {
                    steps: {
                        task: string;
                    }[];
                }, {
                    steps: any[];
                }>>;
            }, "strip", z.ZodTypeAny, {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            }, {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        }, {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        }>>;
        canary: z.ZodOptional<z.ZodObject<{
            deploy: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            preDeploy: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            routeTraffic: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            postRouteTraffic: z.ZodOptional<z.ZodObject<{
                steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    task: string;
                }[], any[]>;
            }, "strip", z.ZodTypeAny, {
                steps: {
                    task: string;
                }[];
            }, {
                steps: any[];
            }>>;
            on: z.ZodOptional<z.ZodObject<{
                failure: z.ZodOptional<z.ZodObject<{
                    steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                        task: string;
                    }[], any[]>;
                }, "strip", z.ZodTypeAny, {
                    steps: {
                        task: string;
                    }[];
                }, {
                    steps: any[];
                }>>;
                success: z.ZodOptional<z.ZodObject<{
                    steps: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                        task: string;
                    }[], any[]>;
                }, "strip", z.ZodTypeAny, {
                    steps: {
                        task: string;
                    }[];
                }, {
                    steps: any[];
                }>>;
            }, "strip", z.ZodTypeAny, {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            }, {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        }, {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        runOnce?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
        rolling?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
        canary?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
    }, {
        runOnce?: {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        } | undefined;
        rolling?: {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        } | undefined;
        canary?: {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        } | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    strategy?: {
        runOnce?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
        rolling?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
        canary?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
    } | undefined;
}, {
    strategy?: {
        runOnce?: {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        } | undefined;
        rolling?: {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        } | undefined;
        canary?: {
            on?: {
                success?: {
                    steps: any[];
                } | undefined;
                failure?: {
                    steps: any[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: any[];
            } | undefined;
            preDeploy?: {
                steps: any[];
            } | undefined;
            routeTraffic?: {
                steps: any[];
            } | undefined;
            postRouteTraffic?: {
                steps: any[];
            } | undefined;
        } | undefined;
    } | undefined;
}>;
export type Deployment = z.infer<typeof Deployment>;
export declare const Jobs: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
    steps: {
        task: string;
    }[];
} | {
    strategy?: {
        runOnce?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
        rolling?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
        canary?: {
            on?: {
                success?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                failure?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            deploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            preDeploy?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            routeTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
            postRouteTraffic?: {
                steps: {
                    task: string;
                }[];
            } | undefined;
        } | undefined;
    } | undefined;
})[], any[]>;
export type Jobs = z.infer<typeof Jobs>;
export declare const Stage: z.ZodObject<{
    jobs: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
        steps: {
            task: string;
        }[];
    } | {
        strategy?: {
            runOnce?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            rolling?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            canary?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
        } | undefined;
    })[], any[]>;
}, "strip", z.ZodTypeAny, {
    jobs: ({
        steps: {
            task: string;
        }[];
    } | {
        strategy?: {
            runOnce?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            rolling?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            canary?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
        } | undefined;
    })[];
}, {
    jobs: any[];
}>;
export type Stage = z.infer<typeof Stage>;
export declare const Container: z.ZodObject<{
    image: z.ZodString;
}, "strip", z.ZodTypeAny, {
    image: string;
}, {
    image: string;
}>;
export type Container = z.infer<typeof Container>;
export declare const Repository: z.ZodObject<{
    type: z.ZodEnum<["git", "github", "bitbucket"]>;
    name: z.ZodString;
    ref: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "bitbucket" | "github" | "git";
    name: string;
    ref?: string | undefined;
}, {
    type: "bitbucket" | "github" | "git";
    name: string;
    ref?: string | undefined;
}>;
export type Repository = z.infer<typeof Repository>;
export declare const Resources: z.ZodObject<{
    repositories: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        type: "bitbucket" | "github" | "git";
        name: string;
        ref?: string | undefined;
    }[], any[]>>;
    containers: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        image: string;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    repositories?: {
        type: "bitbucket" | "github" | "git";
        name: string;
        ref?: string | undefined;
    }[] | undefined;
    containers?: {
        image: string;
    }[] | undefined;
}, {
    repositories?: any[] | undefined;
    containers?: any[] | undefined;
}>;
export type Resources = z.infer<typeof Resources>;
export declare const AzurePipelines: z.ZodObject<{
    resources: z.ZodOptional<z.ZodObject<{
        repositories: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            type: "bitbucket" | "github" | "git";
            name: string;
            ref?: string | undefined;
        }[], any[]>>;
        containers: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            image: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        repositories?: {
            type: "bitbucket" | "github" | "git";
            name: string;
            ref?: string | undefined;
        }[] | undefined;
        containers?: {
            image: string;
        }[] | undefined;
    }, {
        repositories?: any[] | undefined;
        containers?: any[] | undefined;
    }>>;
    stages: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        jobs: ({
            steps: {
                task: string;
            }[];
        } | {
            strategy?: {
                runOnce?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                rolling?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                canary?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
            } | undefined;
        })[];
    }[], any[]>>;
    jobs: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
        steps: {
            task: string;
        }[];
    } | {
        strategy?: {
            runOnce?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            rolling?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            canary?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
        } | undefined;
    })[], any[]>>;
    steps: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        task: string;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    resources?: {
        repositories?: {
            type: "bitbucket" | "github" | "git";
            name: string;
            ref?: string | undefined;
        }[] | undefined;
        containers?: {
            image: string;
        }[] | undefined;
    } | undefined;
    steps?: {
        task: string;
    }[] | undefined;
    jobs?: ({
        steps: {
            task: string;
        }[];
    } | {
        strategy?: {
            runOnce?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            rolling?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            canary?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
        } | undefined;
    })[] | undefined;
    stages?: {
        jobs: ({
            steps: {
                task: string;
            }[];
        } | {
            strategy?: {
                runOnce?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                rolling?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                canary?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
            } | undefined;
        })[];
    }[] | undefined;
}, {
    resources?: {
        repositories?: any[] | undefined;
        containers?: any[] | undefined;
    } | undefined;
    steps?: any[] | undefined;
    jobs?: any[] | undefined;
    stages?: any[] | undefined;
}>;
export type AzurePipelines = z.infer<typeof AzurePipelines>;
export declare const AzurePipelinesYaml: z.ZodPipeline<z.ZodEffects<z.ZodString, string | number | boolean | import("type-fest").JsonObject | import("type-fest").JsonValue[] | readonly import("type-fest").JsonValue[] | null, string>, z.ZodObject<{
    resources: z.ZodOptional<z.ZodObject<{
        repositories: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            type: "bitbucket" | "github" | "git";
            name: string;
            ref?: string | undefined;
        }[], any[]>>;
        containers: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            image: string;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        repositories?: {
            type: "bitbucket" | "github" | "git";
            name: string;
            ref?: string | undefined;
        }[] | undefined;
        containers?: {
            image: string;
        }[] | undefined;
    }, {
        repositories?: any[] | undefined;
        containers?: any[] | undefined;
    }>>;
    stages: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        jobs: ({
            steps: {
                task: string;
            }[];
        } | {
            strategy?: {
                runOnce?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                rolling?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                canary?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
            } | undefined;
        })[];
    }[], any[]>>;
    jobs: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
        steps: {
            task: string;
        }[];
    } | {
        strategy?: {
            runOnce?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            rolling?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            canary?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
        } | undefined;
    })[], any[]>>;
    steps: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        task: string;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    resources?: {
        repositories?: {
            type: "bitbucket" | "github" | "git";
            name: string;
            ref?: string | undefined;
        }[] | undefined;
        containers?: {
            image: string;
        }[] | undefined;
    } | undefined;
    steps?: {
        task: string;
    }[] | undefined;
    jobs?: ({
        steps: {
            task: string;
        }[];
    } | {
        strategy?: {
            runOnce?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            rolling?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
            canary?: {
                on?: {
                    success?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    failure?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                deploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                preDeploy?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                routeTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
                postRouteTraffic?: {
                    steps: {
                        task: string;
                    }[];
                } | undefined;
            } | undefined;
        } | undefined;
    })[] | undefined;
    stages?: {
        jobs: ({
            steps: {
                task: string;
            }[];
        } | {
            strategy?: {
                runOnce?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                rolling?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
                canary?: {
                    on?: {
                        success?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                        failure?: {
                            steps: {
                                task: string;
                            }[];
                        } | undefined;
                    } | undefined;
                    deploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    preDeploy?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    routeTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                    postRouteTraffic?: {
                        steps: {
                            task: string;
                        }[];
                    } | undefined;
                } | undefined;
            } | undefined;
        })[];
    }[] | undefined;
}, {
    resources?: {
        repositories?: any[] | undefined;
        containers?: any[] | undefined;
    } | undefined;
    steps?: any[] | undefined;
    jobs?: any[] | undefined;
    stages?: any[] | undefined;
}>>;
