"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.extractPackageFile = void 0;
const azure_pipelines_tasks_1 = require("../../datasource/azure-pipelines-tasks");
const git_tags_1 = require("../../datasource/git-tags");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.url = 'https://learn.microsoft.com/azure/devops/pipelines';
exports.categories = ['ci'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/(^|/).azuredevops/.+\\.ya?ml$/',
        '/azure.*pipelines?.*\\.ya?ml$/',
    ],
    enabled: false,
};
exports.supportedDatasources = [
    azure_pipelines_tasks_1.AzurePipelinesTasksDatasource.id,
    git_tags_1.GitTagsDatasource.id,
];
//# sourceMappingURL=index.js.map