"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const ignore_1 = require("../../../util/ignore");
const regex_1 = require("../../../util/regex");
const upgradeable_tooling_1 = require("./upgradeable-tooling");
function extractPackageFile(content) {
    logger_1.logger.trace(`asdf.extractPackageFile()`);
    const regex = (0, regex_1.regEx)(/^(?<toolName>([\w_-]+)) +(?<version>[^\s#]+)(?: +[^\s#]+)* *(?: #(?<comment>.*))?$/gm);
    const deps = [];
    for (const groups of [...content.matchAll(regex)]
        .map((m) => m.groups)
        .filter(is_1.default.truthy)) {
        const depName = groups.toolName.trim();
        const version = groups.version.trim();
        const toolConfig = upgradeable_tooling_1.upgradeableTooling[depName];
        const toolDefinition = toolConfig
            ? typeof toolConfig.config === 'function'
                ? toolConfig.config(version)
                : toolConfig.config
            : undefined;
        if (toolDefinition) {
            const dep = {
                currentValue: version,
                depName,
                ...toolDefinition,
            };
            if ((0, ignore_1.isSkipComment)((groups.comment ?? '').trim())) {
                dep.skipReason = 'ignored';
            }
            deps.push(dep);
        }
        else {
            const dep = {
                depName,
                skipReason: 'unsupported-datasource',
            };
            deps.push(dep);
        }
    }
    return deps.length ? { deps } : null;
}
//# sourceMappingURL=extract.js.map