"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationDefinitionSchema = exports.ApplicationDefinition = exports.ApplicationSet = exports.Application = exports.ApplicationSpec = exports.ApplicationSource = exports.ApplicationKustomize = exports.KubernetesResource = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
exports.KubernetesResource = zod_1.z.object({
    apiVersion: zod_1.z.string(),
});
exports.ApplicationKustomize = zod_1.z.object({
    images: (0, schema_utils_1.LooseArray)(zod_1.z.string()).optional(),
});
exports.ApplicationSource = zod_1.z.object({
    chart: zod_1.z.string().optional(),
    repoURL: zod_1.z.string(),
    targetRevision: zod_1.z.string(),
    kustomize: exports.ApplicationKustomize.optional(),
});
exports.ApplicationSpec = zod_1.z.object({
    source: exports.ApplicationSource.optional(),
    sources: (0, schema_utils_1.LooseArray)(exports.ApplicationSource).optional(),
});
exports.Application = exports.KubernetesResource.extend({
    kind: zod_1.z.literal('Application'),
    spec: exports.ApplicationSpec,
});
exports.ApplicationSet = exports.KubernetesResource.extend({
    kind: zod_1.z.literal('ApplicationSet'),
    spec: zod_1.z.object({
        template: zod_1.z.object({
            spec: exports.ApplicationSpec,
        }),
    }),
});
exports.ApplicationDefinition = exports.Application.or(exports.ApplicationSet);
exports.ApplicationDefinitionSchema = (0, schema_utils_1.multidocYaml)({
    removeTemplates: true,
}).pipe((0, schema_utils_1.LooseArray)(exports.ApplicationDefinition));
//# sourceMappingURL=schema.js.map