import { z } from 'zod';
export declare const KubernetesResource: z.ZodObject<{
    apiVersion: z.ZodString;
}, "strip", z.ZodTypeAny, {
    apiVersion: string;
}, {
    apiVersion: string;
}>;
export declare const ApplicationKustomize: z.ZodObject<{
    images: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
}, "strip", z.ZodTypeAny, {
    images?: string[] | undefined;
}, {
    images?: any[] | undefined;
}>;
export declare const ApplicationSource: z.ZodObject<{
    chart: z.ZodOptional<z.ZodString>;
    repoURL: z.ZodString;
    targetRevision: z.ZodString;
    kustomize: z.ZodOptional<z.ZodObject<{
        images: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        images?: string[] | undefined;
    }, {
        images?: any[] | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    repoURL: string;
    targetRevision: string;
    kustomize?: {
        images?: string[] | undefined;
    } | undefined;
    chart?: string | undefined;
}, {
    repoURL: string;
    targetRevision: string;
    kustomize?: {
        images?: any[] | undefined;
    } | undefined;
    chart?: string | undefined;
}>;
export type ApplicationSource = z.infer<typeof ApplicationSource>;
export declare const ApplicationSpec: z.ZodObject<{
    source: z.ZodOptional<z.ZodObject<{
        chart: z.ZodOptional<z.ZodString>;
        repoURL: z.ZodString;
        targetRevision: z.ZodString;
        kustomize: z.ZodOptional<z.ZodObject<{
            images: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
        }, "strip", z.ZodTypeAny, {
            images?: string[] | undefined;
        }, {
            images?: any[] | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        repoURL: string;
        targetRevision: string;
        kustomize?: {
            images?: string[] | undefined;
        } | undefined;
        chart?: string | undefined;
    }, {
        repoURL: string;
        targetRevision: string;
        kustomize?: {
            images?: any[] | undefined;
        } | undefined;
        chart?: string | undefined;
    }>>;
    sources: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        repoURL: string;
        targetRevision: string;
        kustomize?: {
            images?: string[] | undefined;
        } | undefined;
        chart?: string | undefined;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    source?: {
        repoURL: string;
        targetRevision: string;
        kustomize?: {
            images?: string[] | undefined;
        } | undefined;
        chart?: string | undefined;
    } | undefined;
    sources?: {
        repoURL: string;
        targetRevision: string;
        kustomize?: {
            images?: string[] | undefined;
        } | undefined;
        chart?: string | undefined;
    }[] | undefined;
}, {
    source?: {
        repoURL: string;
        targetRevision: string;
        kustomize?: {
            images?: any[] | undefined;
        } | undefined;
        chart?: string | undefined;
    } | undefined;
    sources?: any[] | undefined;
}>;
export type ApplicationSpec = z.infer<typeof ApplicationSpec>;
export declare const Application: z.ZodObject<{
    apiVersion: z.ZodString;
} & {
    kind: z.ZodLiteral<"Application">;
    spec: z.ZodObject<{
        source: z.ZodOptional<z.ZodObject<{
            chart: z.ZodOptional<z.ZodString>;
            repoURL: z.ZodString;
            targetRevision: z.ZodString;
            kustomize: z.ZodOptional<z.ZodObject<{
                images: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
            }, "strip", z.ZodTypeAny, {
                images?: string[] | undefined;
            }, {
                images?: any[] | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }, {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: any[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }>>;
        sources: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }[] | undefined;
    }, {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: any[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: any[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    apiVersion: string;
    kind: "Application";
    spec: {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }[] | undefined;
    };
}, {
    apiVersion: string;
    kind: "Application";
    spec: {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: any[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: any[] | undefined;
    };
}>;
export declare const ApplicationSet: z.ZodObject<{
    apiVersion: z.ZodString;
} & {
    kind: z.ZodLiteral<"ApplicationSet">;
    spec: z.ZodObject<{
        template: z.ZodObject<{
            spec: z.ZodObject<{
                source: z.ZodOptional<z.ZodObject<{
                    chart: z.ZodOptional<z.ZodString>;
                    repoURL: z.ZodString;
                    targetRevision: z.ZodString;
                    kustomize: z.ZodOptional<z.ZodObject<{
                        images: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
                    }, "strip", z.ZodTypeAny, {
                        images?: string[] | undefined;
                    }, {
                        images?: any[] | undefined;
                    }>>;
                }, "strip", z.ZodTypeAny, {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }, {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }>>;
                sources: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[], any[]>>;
            }, "strip", z.ZodTypeAny, {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            }, {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: any[] | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            };
        }, {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: any[] | undefined;
            };
        }>;
    }, "strip", z.ZodTypeAny, {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            };
        };
    }, {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: any[] | undefined;
            };
        };
    }>;
}, "strip", z.ZodTypeAny, {
    apiVersion: string;
    kind: "ApplicationSet";
    spec: {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            };
        };
    };
}, {
    apiVersion: string;
    kind: "ApplicationSet";
    spec: {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: any[] | undefined;
            };
        };
    };
}>;
export declare const ApplicationDefinition: z.ZodUnion<[z.ZodObject<{
    apiVersion: z.ZodString;
} & {
    kind: z.ZodLiteral<"Application">;
    spec: z.ZodObject<{
        source: z.ZodOptional<z.ZodObject<{
            chart: z.ZodOptional<z.ZodString>;
            repoURL: z.ZodString;
            targetRevision: z.ZodString;
            kustomize: z.ZodOptional<z.ZodObject<{
                images: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
            }, "strip", z.ZodTypeAny, {
                images?: string[] | undefined;
            }, {
                images?: any[] | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }, {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: any[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }>>;
        sources: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }[], any[]>>;
    }, "strip", z.ZodTypeAny, {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }[] | undefined;
    }, {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: any[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: any[] | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    apiVersion: string;
    kind: "Application";
    spec: {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }[] | undefined;
    };
}, {
    apiVersion: string;
    kind: "Application";
    spec: {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: any[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: any[] | undefined;
    };
}>, z.ZodObject<{
    apiVersion: z.ZodString;
} & {
    kind: z.ZodLiteral<"ApplicationSet">;
    spec: z.ZodObject<{
        template: z.ZodObject<{
            spec: z.ZodObject<{
                source: z.ZodOptional<z.ZodObject<{
                    chart: z.ZodOptional<z.ZodString>;
                    repoURL: z.ZodString;
                    targetRevision: z.ZodString;
                    kustomize: z.ZodOptional<z.ZodObject<{
                        images: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>;
                    }, "strip", z.ZodTypeAny, {
                        images?: string[] | undefined;
                    }, {
                        images?: any[] | undefined;
                    }>>;
                }, "strip", z.ZodTypeAny, {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }, {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }>>;
                sources: z.ZodOptional<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[], any[]>>;
            }, "strip", z.ZodTypeAny, {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            }, {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: any[] | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            };
        }, {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: any[] | undefined;
            };
        }>;
    }, "strip", z.ZodTypeAny, {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            };
        };
    }, {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: any[] | undefined;
            };
        };
    }>;
}, "strip", z.ZodTypeAny, {
    apiVersion: string;
    kind: "ApplicationSet";
    spec: {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            };
        };
    };
}, {
    apiVersion: string;
    kind: "ApplicationSet";
    spec: {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: any[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: any[] | undefined;
            };
        };
    };
}>]>;
export type ApplicationDefinition = z.infer<typeof ApplicationDefinition>;
export declare const ApplicationDefinitionSchema: z.ZodPipeline<z.ZodEffects<z.ZodString, import("type-fest").JsonArray, string>, z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
    apiVersion: string;
    kind: "Application";
    spec: {
        source?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        } | undefined;
        sources?: {
            repoURL: string;
            targetRevision: string;
            kustomize?: {
                images?: string[] | undefined;
            } | undefined;
            chart?: string | undefined;
        }[] | undefined;
    };
} | {
    apiVersion: string;
    kind: "ApplicationSet";
    spec: {
        template: {
            spec: {
                source?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                } | undefined;
                sources?: {
                    repoURL: string;
                    targetRevision: string;
                    kustomize?: {
                        images?: string[] | undefined;
                    } | undefined;
                    chart?: string | undefined;
                }[] | undefined;
            };
        };
    };
})[], any[]>>;
