"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.extractPackageFile = void 0;
const docker_1 = require("../../datasource/docker");
const git_tags_1 = require("../../datasource/git-tags");
const helm_1 = require("../../datasource/helm");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'Argo CD';
exports.url = 'https://argo-cd.readthedocs.io';
exports.categories = ['kubernetes', 'cd'];
exports.defaultConfig = {
    managerFilePatterns: [],
};
exports.supportedDatasources = [
    docker_1.DockerDatasource.id,
    git_tags_1.GitTagsDatasource.id,
    helm_1.HelmDatasource.id,
];
//# sourceMappingURL=index.js.map