"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const logger_1 = require("../../../logger");
const regex_1 = require("../../../util/regex");
const extract_1 = require("../dockerfile/extract");
function extractPackageFile(content, packageFile, config) {
    logger_1.logger.trace(`ansible.extractPackageFile(${packageFile})`);
    let deps = [];
    const re = (0, regex_1.regEx)(/^\s*image:\s*'?"?([^\s'"]+)'?"?\s*$/);
    for (const line of content.split(regex_1.newlineRegex)) {
        const match = re.exec(line);
        if (match) {
            const currentFrom = match[1];
            const dep = (0, extract_1.getDep)(currentFrom, true, config.registryAliases);
            logger_1.logger.debug({
                depName: dep.depName,
                currentValue: dep.currentValue,
                currentDigest: dep.currentDigest,
            }, 'Docker image inside ansible');
            deps.push(dep);
        }
    }
    deps = deps.filter((dep) => !dep.currentValue?.includes('${'));
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map