import { z } from 'zod';
export declare const UnityReleasesJSON: z.ZodObject<{
    total: z.ZodNumber;
    results: z.ZodArray<z.ZodObject<{
        version: z.ZodString;
        releaseDate: z.ZodString;
        releaseNotes: z.ZodObject<{
            url: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            url: string;
        }, {
            url: string;
        }>;
        shortRevision: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        version: string;
        releaseNotes: {
            url: string;
        };
        releaseDate: string;
        shortRevision: string;
    }, {
        version: string;
        releaseNotes: {
            url: string;
        };
        releaseDate: string;
        shortRevision: string;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    results: {
        version: string;
        releaseNotes: {
            url: string;
        };
        releaseDate: string;
        shortRevision: string;
    }[];
    total: number;
}, {
    results: {
        version: string;
        releaseNotes: {
            url: string;
        };
        releaseDate: string;
        shortRevision: string;
    }[];
    total: number;
}>;
export type UnityReleasesJSON = z.infer<typeof UnityReleasesJSON>;
