import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class Unity3dDatasource extends Datasource {
    static readonly baseUrl = "https://services.api.unity.com/unity/editor/release/v1/releases";
    static readonly homepage = "https://unity.com/";
    static readonly streams: Record<string, string>;
    static readonly legacyStreams: Record<string, string>;
    static readonly limit: number;
    static readonly id = "unity3d";
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "unity3d";
    readonly registryStrategy = "merge";
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `releaseDate` field in the results.";
    constructor();
    translateStream(registryUrl: string): string;
    getByStream(registryUrl: string | undefined, withHash: boolean): Promise<ReleaseResult | null>;
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
}
