"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Unity3dPackagesDatasource = void 0;
const tslib_1 = require("tslib");
const decorator_1 = require("../../../util/cache/package/decorator");
const timestamp_1 = require("../../../util/timestamp");
const Unity3dPackagesVersioning = tslib_1.__importStar(require("../../versioning/unity3d-packages"));
const datasource_1 = require("../datasource");
const schema_1 = require("./schema");
class Unity3dPackagesDatasource extends datasource_1.Datasource {
    static id = 'unity3d-packages';
    static defaultRegistryUrl = 'https://packages.unity.com';
    defaultRegistryUrls = [
        Unity3dPackagesDatasource.defaultRegistryUrl,
    ];
    defaultVersioning = Unity3dPackagesVersioning.id;
    constructor() {
        super(Unity3dPackagesDatasource.id);
    }
    async getReleases({ packageName, registryUrl, }) {
        const response = await this.http.getJson(`${registryUrl}/${packageName}`, schema_1.UnityPackageReleasesJSON);
        const usingDefaultRegistry = registryUrl === Unity3dPackagesDatasource.defaultRegistryUrl;
        const versions = Object.values(response.body.versions);
        const result = {
            releases: [],
            homepage: versions?.[0]?.documentationUrl,
            registryUrl,
        };
        for (const release of versions) {
            result.releases.push({
                version: release.version,
                releaseTimestamp: (0, timestamp_1.asTimestamp)(response.body.time[release.version]),
                changelogContent: release._upm?.changelog,
                changelogUrl: usingDefaultRegistry
                    ? release.documentationUrl?.replace('manual/index.html', 'changelog/CHANGELOG.html')
                    : undefined,
                isStable: Unity3dPackagesVersioning.default.isStable(release.version),
                registryUrl,
            });
        }
        return result;
    }
}
exports.Unity3dPackagesDatasource = Unity3dPackagesDatasource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${Unity3dPackagesDatasource.id}`,
        key: ({ registryUrl, packageName }) => `${registryUrl}:${packageName}`,
    })
], Unity3dPackagesDatasource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map