import type { Http } from '../../../util/http';
import { Result } from '../../../util/result';
type PackageVersions = Map<string, string[]>;
interface VersionsEndpointData {
    packageVersions: PackageVersions;
    syncedAt: Date;
    contentLength: number;
    /**
     * Last 33 characters of the response (32 hex digits + newline)
     */
    contentTail: string;
}
type VersionsEndpointResult = Result<VersionsEndpointData, 'unsupported-api'>;
export declare const memCache: Map<string, VersionsEndpointResult>;
export type VersionsResult = Result<string[], 'unsupported-api' | 'package-not-found'>;
export declare class VersionsEndpointCache {
    private readonly http;
    constructor(http: Http);
    private cacheRequests;
    /**
     * At any given time, there should only be one request for a given registryUrl.
     */
    private getCache;
    getVersions(registryUrl: string, packageName: string): Promise<VersionsResult>;
    private fullSync;
    private deltaSync;
}
export {};
