"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GemInfo = exports.GemVersions = exports.GemMetadata = exports.MarshalledVersionInfo = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const zod_1 = require("zod");
const filter_map_1 = require("../../../util/filter-map");
const regex_1 = require("../../../util/regex");
const schema_utils_1 = require("../../../util/schema-utils");
const timestamp_1 = require("../../../util/timestamp");
exports.MarshalledVersionInfo = (0, schema_utils_1.LooseArray)(zod_1.z
    .object({ number: zod_1.z.string() })
    .transform(({ number: version }) => ({ version })))
    .refine((value) => !is_1.default.emptyArray(value), 'Empty response from `/v1/dependencies` endpoint')
    .transform((releases) => ({ releases }));
exports.GemMetadata = zod_1.z
    .object({
    changelog_uri: zod_1.z.string().optional().catch(undefined),
    homepage_uri: zod_1.z.string().optional().catch(undefined),
    source_code_uri: zod_1.z.string().optional().catch(undefined),
})
    .transform(({ changelog_uri: changelogUrl, homepage_uri: homepage, source_code_uri: sourceUrl, }) => ({ changelogUrl, homepage, sourceUrl }));
exports.GemVersions = (0, schema_utils_1.LooseArray)(zod_1.z
    .object({
    number: zod_1.z.string(),
    created_at: timestamp_1.MaybeTimestamp,
    platform: zod_1.z.string().optional().catch(undefined),
    ruby_version: zod_1.z.string().optional().catch(undefined),
    rubygems_version: zod_1.z.string().optional().catch(undefined),
    metadata: zod_1.z
        .object({
        changelog_uri: zod_1.z.string().optional().catch(undefined),
        source_code_uri: zod_1.z.string().optional().catch(undefined),
    })
        .catch({}),
})
    .transform(({ number: version, created_at: releaseTimestamp, platform, ruby_version: rubyVersion, rubygems_version: rubygemsVersion, metadata, }) => {
    const result = { version, releaseTimestamp };
    const constraints = {};
    if (platform) {
        constraints.platform = [platform];
    }
    if (rubyVersion) {
        constraints.ruby = [rubyVersion];
    }
    if (rubygemsVersion) {
        constraints.rubygems = [rubygemsVersion];
    }
    if (!is_1.default.emptyObject(constraints)) {
        result.constraints = constraints;
    }
    if (metadata.changelog_uri) {
        result.changelogUrl = metadata.changelog_uri;
    }
    if (metadata.source_code_uri) {
        result.sourceUrl = metadata.source_code_uri;
    }
    return result;
}))
    .refine((value) => !is_1.default.emptyArray(value), 'Empty response from `/v1/gems` endpoint')
    .transform((releases) => ({ releases }));
exports.GemInfo = zod_1.z
    .string()
    .transform((body) => (0, filter_map_1.filterMap)(body.split(regex_1.newlineRegex), (line) => {
    const spaceIdx = line.indexOf(' ');
    return spaceIdx > 0 ? line.slice(0, spaceIdx) : null;
}).map((version) => ({ version })))
    .refine((value) => !is_1.default.emptyArray(value), 'Empty response from `/info` endpoint')
    .transform((releases) => ({ releases }));
//# sourceMappingURL=schema.js.map