import { z } from 'zod';
import type { Release } from '../types';
export declare const MarshalledVersionInfo: z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, Release[], any[]>, Release[], any[]>, {
    releases: Release[];
}, any[]>;
export declare const GemMetadata: z.ZodEffects<z.ZodObject<{
    changelog_uri: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    homepage_uri: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    source_code_uri: z.ZodCatch<z.ZodOptional<z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    changelog_uri?: string | undefined;
    homepage_uri?: string | undefined;
    source_code_uri?: string | undefined;
}, {
    changelog_uri?: unknown;
    homepage_uri?: unknown;
    source_code_uri?: unknown;
}>, {
    changelogUrl: string | undefined;
    homepage: string | undefined;
    sourceUrl: string | undefined;
}, {
    changelog_uri?: unknown;
    homepage_uri?: unknown;
    source_code_uri?: unknown;
}>;
export type GemMetadata = z.infer<typeof GemMetadata>;
export declare const GemVersions: z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, Release[], any[]>, Release[], any[]>, {
    releases: Release[];
}, any[]>;
export type GemVersions = z.infer<typeof GemVersions>;
export declare const GemInfo: z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodString, Release[], string>, Release[], string>, {
    releases: Release[];
}, string>;
export type GemInfo = z.infer<typeof GemInfo>;
