import { Datasource } from '../datasource';
import type { GetReleasesConfig, ReleaseResult } from '../types';
export declare class RubygemsDatasource extends Datasource {
    static readonly id = "rubygems";
    private metadataCache;
    constructor();
    readonly defaultRegistryUrls: string[];
    readonly defaultVersioning = "ruby";
    readonly registryStrategy = "hunt";
    private readonly versionsEndpointCache;
    readonly releaseTimestampSupport = true;
    readonly releaseTimestampNote = "The release timestamp is determined from the `created_at` field in the results.";
    readonly sourceUrlSupport = "release";
    readonly sourceUrlNote = "The source URL is determined from the `source_code_uri` field in the results.";
    getReleases({ packageName, registryUrl, }: GetReleasesConfig): Promise<ReleaseResult | null>;
    private getReleasesViaInfoEndpoint;
    private getReleasesViaDeprecatedAPI;
}
