import type { Http, SafeJsonError } from '../../../util/http';
import type { AsyncResult } from '../../../util/result';
import type { ReleaseResult } from '../types';
import { GemMetadata } from './schema';
export declare function assignMetadata(releases: ReleaseResult, metadata: GemMetadata): ReleaseResult;
export declare function getV1Metadata(http: Http, registryUrl: string, packageName: string): AsyncResult<GemMetadata, SafeJsonError>;
export declare function getV1Releases(http: Http, registryUrl: string, packageName: string): AsyncResult<ReleaseResult, SafeJsonError | 'unsupported-api'>;
